% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODISoptions.R
\name{MODISoptions}
\alias{MODISoptions}
\title{Set or Retrieve Permanent MODIS Package Options}
\usage{
MODISoptions(localArcPath, outDirPath, pixelSize, outProj, resamplingType,
  dataFormat, gdalPath, MODISserverOrder, dlmethod, stubbornness, wait, quiet,
  systemwide = FALSE, save = TRUE, checkTools = TRUE)
}
\arguments{
\item{localArcPath}{\code{character}, defaults to \code{"~/MODIS_ARC"}. 
Target folder for downloaded MODIS HDF files.}

\item{outDirPath}{\code{character}, defaults to \code{"~/MODIS_ARC/PROCESSED"}. 
Target folder for results of \code{\link{runGdal}} and \code{\link{runMrt}}.}

\item{pixelSize}{Output pixel size (in target reference system units) passed 
to \code{\link{runGdal}} and \code{\link{runMrt}}, defaults to \code{"asIn"}.}

\item{outProj}{Target reference system passed to \code{\link{runGdal}} and 
\code{\link{runMrt}}. \code{\link{runGdal}} requires a valid 
\code{\link{CRS}}. As for \code{\link{runMrt}}, please consult the MRT manual. 
Since the two pocessing methods do not have common methods, it is suggested 
to stick with the default settings (see Details).}

\item{resamplingType}{Defaults to \code{"NN"} (Nearest Neightbour). MRT and 
GDAL both support \code{c('NN', 'CC', 'BIL')}. In addition, GDAL supports 
\code{cubicspline} and \code{lanczos} and, from \code{GDAL >= 1.10.0} onwards, 
also \code{mode} and \code{average}.}

\item{dataFormat}{\code{character}, defaults to \code{"GTiff"}. One of 
\code{getOption("MODIS_gdalOutDriver")} (column 'name').}

\item{gdalPath}{\code{character}. Path to gdal bin directory and more 
relevant for Windows users. Use \code{MODIS:::checkTools("GDAL")} to try to 
detect it automatically.}

\item{MODISserverOrder}{\code{character}. Possible options are \code{"LAADS"}
(default) and \code{"LPDAAC"} (see 'dlmethod' and 'Details'). If only one 
server is selected, all efforts to download data from the second server 
available are inhibited.}

\item{dlmethod}{\code{character}, defaults to \code{auto}. See 'method' in 
\code{\link{download.file}}. On Unix (also Mac?), it is suggested to use 
\code{"wget"} or, if installed, \code{"aria2"}. In order to download MODIS 
files from LPDAAC, please note that either wget (default) or curl must be 
installed and made available through the PATH environmental variable.}

\item{stubbornness}{\code{numeric}. The number of retries after the target 
server has refused a connection. Higher values increase the chance of getting 
the file, but also lead to hanging functions if the server is down.}

\item{wait}{\code{numeric} waiting time (in seconds) inserted after each 
internal online download call via \code{\link{download.file}} or 
\code{\link{getURL}}. Reduces the chance of FTP connection errors that 
frequently occur after many requests.}

\item{quiet}{\code{logical} passed eg to \code{\link{download.file}} which is 
called from inside \code{\link{getHdf}}.}

\item{systemwide}{\code{logical}. If \code{FALSE} (default), 'user'-wide 
settings are saved to \code{path.expand("~/.MODIS_Opts.R")}. If \code{TRUE}, 
write settings to 'systemwide', presumed you have write access to 
\code{paste(R.home(component="etc"), '/', '.MODIS_Opts.R', sep='')}.}

\item{save}{\code{logical}. If \code{TRUE} (default), settings are permanent.}

\item{checkTools}{\code{logical}, defaults to \code{TRUE}. Check if external 
tools (i.e., GDAL and MRT) are installed and reachable through R.}
}
\value{
An invisible \code{list} of \strong{MODIS} options. In addition, the most 
relevant of these options are printed to the console. Use 
\code{\link{capture.output}} to prevent this behavior.
}
\description{
Set or retrieve persistant \strong{MODIS} package options (per user or 
systemwide). Changes here will persist through sessions and updates.
}
\details{
These settings are permanent, easy to change and take effect immediately!

If you change default values, consider that your settings have to be valid 
for any MODIS product, layer and area!

It is not recommended to use 
\itemize{
\item{a coordinate reference system that is not applicable globally as 
default for 'outProj',}
\item{or a fixed 'pixelSize' for different products,}
\item{or a 'resamplingType' that is not \code{"NN"}.}
}

'localArcPath' and 'outDirPath' should be changed, expecially on a Windows 
OS, as '~/MODIS_ARC/...' is normally on the 'C:/...' drive. You may also 
specify a shared network drive if you have a central MODIS data server. 

On Windows, you have to set 'gdalPath' to the location of GDAL executables 
(i.e., the '.../GDAL../bin' directory). On Unix-alikes, this should not be 
required unless you want to specify a non-default GDAL installation.

On an unixoid OS, it is suggested to use \code{dlmethod = 'wget'} because it 
is a reliable tool and, after the change of the 'LP DAAC' datapool from FTP 
to HTTP (May 2013), \code{dlmethod = 'auto'} seems not to work properly. On 
Windows, on the other hand, \code{dlmethod = 'auto'} seems to work fine. 

Please note that in order to download MODIS files from LPDAAC, you are 
required to register for an Earthdata Login Profile 
(\url{https://urs.earthdata.nasa.gov/users/new}) and create a read-only 
.netrc file in your home directory containing the Earthdata server address as 
well as your login credentials. An automated solution for the creation of a 
workable .netrc file is provided through \code{\link{lpdaacLogin}}.
}
\examples{
\dontrun{
## get options
MODISoptions()

## set options
MODISoptions(localArcPath="/another/path/than/default")
}

}
\author{
Matteo Mattiuzzi, Steven Mosher and Florian Detsch
}
