% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callOpenTiles.R
\docType{methods}
\name{callOpenTiles}
\alias{callOpenTiles}
\alias{callOpenTiles,GRangesList-method}
\alias{callOpenTiles,list-method}
\alias{.callOpenTiles_ArchR}
\alias{callOpenTiles,ArchRProject-method}
\title{\code{callOpenTiles} Perform peak-calling on a set of fragments or an ArchR Project.}
\usage{
callOpenTiles(
  ATACFragments,
  cellColData,
  blackList,
  genome,
  cellPopLabel,
  cellPopulations = "ALL",
  studySignal = NULL,
  TxDb,
  Org,
  outDir,
  fast = FALSE,
  numCores = 30,
  verbose = FALSE,
  force = FALSE
)

\S4method{callOpenTiles}{GRangesList}(
  ATACFragments,
  cellColData,
  blackList,
  genome,
  cellPopLabel,
  cellPopulations = "ALL",
  studySignal = NULL,
  TxDb,
  Org,
  outDir,
  numCores = 30,
  verbose = FALSE,
  force = FALSE
)

\S4method{callOpenTiles}{list}(
  ATACFragments,
  cellColData,
  blackList,
  genome,
  cellPopLabel,
  cellPopulations = "ALL",
  studySignal = NULL,
  TxDb,
  Org,
  outDir,
  numCores = 30,
  verbose = FALSE,
  force = FALSE
)

.callOpenTiles_ArchR(
  ATACFragments,
  cellPopLabel,
  cellPopulations = "ALL",
  studySignal = NULL,
  TxDb,
  Org,
  outDir = NULL,
  fast = FALSE,
  numCores = 30,
  verbose = FALSE,
  force = FALSE
)
}
\arguments{
\item{ATACFragments}{an ArchR Project, or a GRangesList of fragments}

\item{cellColData}{A DataFrame containing cell-level metadata and a 'Sample' column}

\item{blackList}{A GRanges of blacklisted regions}

\item{genome}{A valid BSGenome object describing the genome of your organism}

\item{cellPopLabel}{string indicating which column in the ArchRProject
metadata contains the cell population label.}

\item{cellPopulations}{vector of strings. Cell subsets for which to call
peaks. This list of group names must be identical to names that appear in
the ArchRProject metadata.  Optional, if cellPopulations='ALL', then peak
calling is done on all cell populations in the ArchR project metadata.
Default is 'ALL'.}

\item{studySignal}{The median signal (number of fragments) in your study. If not
set, this will be calculated using the input ArchR project but relies on
the assumption that the ArchR project encompasses your whole study (i.e. is
not a subset).}

\item{TxDb}{is an AnnotationDbi object with transcript info for the organism.}

\item{Org}{is the genome-wide annotation package for your organism.}

\item{outDir}{is a string describing the output directory for coverage files
and TxDb/Org. Must be a complete directory string. With ArchR input,
set outDir to NULL to create a directory within the input ArchR project 
directory named MOCHA for saving files.}

\item{fast}{Optional, set to TRUE to use a faster but more memory-intensive}

\item{numCores}{integer. Number of cores to parallelize peak-calling across
multiple cell populations.}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}

\item{force}{Optional, whether to force creation of coverage files if they
already exist. Default is FALSE.}
}
\value{
tileResults A MultiAssayExperiment object containing ranged data for
  each tile
}
\description{
\code{callOpenTiles} is the main peak-calling function in MOCHA
  that serves as a wrapper function to call peaks provided a set of fragment
  files and an ArchR Project for meta-data purposes
}
\examples{
\dontrun{
# Starting from an ArchR Project:
library(TxDb.Hsapiens.UCSC.hg38.refGene)
library(org.Hs.eg.db)
tileResults <- MOCHA::callOpenTiles(
  ArchRProj = myArchRProj,
  cellPopLabel = "celltype_labeling",
  cellPopulations = "CD4",
  TxDb = TxDb.Hsapiens.UCSC.hg38.refGene,
  Org = org.Hs.eg.db,
  numCores = 1
)
}
\donttest{
# Starting from GRangesList
if (
  require(BSgenome.Hsapiens.UCSC.hg19) && 
  require(TxDb.Hsapiens.UCSC.hg38.refGene) && 
  require(org.Hs.eg.db)
) {
tiles <- MOCHA::callOpenTiles(
  ATACFragments = MOCHA::exampleFragments,
  cellColData = MOCHA::exampleCellColData,
  blackList = MOCHA::exampleBlackList,
  genome = BSgenome.Hsapiens.UCSC.hg19,
  TxDb = TxDb.Hsapiens.UCSC.hg38.refGene,
  Org = org.Hs.eg.db,
  outDir = tempdir(),
  cellPopLabel = "Clusters",
  cellPopulations = c("C2", "C5"),
  numCores = 1
)
}
}

}
