% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMLR.R
\name{Xreg}
\alias{Xreg}
\title{Preparing data for parameter estimation procedure}
\usage{
Xreg(tGiven, initState, X, lambda)
}
\arguments{
\item{tGiven}{Vector n}

\item{initState}{Vector n}

\item{X}{Matrix (n x k+1), k – number of regressors (plus intercept)}

\item{lambda}{Matrix (m x m), m – number of states}
}
\value{
Matrix (n x 2(k+1))
}
\description{
Regressors matrix formation taking into account observation times and initial states.
Kronecker product is used.
}
\details{
Function calculates the following expression
addImage(doc, "matrix.png")
where vector of average sojourn times in each state is calculated using function Aver_soj_time.
\figure{matrix.png}{Fig.1}
}
\examples{
X <- cbind(rep_len(1,10),c(2,5,7,3,1,1,2,2,3,6), c(5,9,1,2,3,2,3,5,2,2))
tGiven <- matrix (c(6,4.8,1,2.6,6.4,1.7,2.9,4.4,1.5,3.4), nrow = 10, ncol = 1)
initState <- matrix (c(2,1,1,2,2,2,1,1,2,1),nrow = 10, ncol = 1)
lambda <- matrix(c(0, 0.33, 0.45, 0), nrow = 2, ncol = 2, byrow = TRUE)
Xreg(tGiven, initState, X, lambda)
}
