% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moidecoder.R
\name{decoder_snp}
\alias{decoder_snp}
\title{Converts ambeguity codes to represented bases}
\usage{
decoder_snp(
  y,
  c_l,
  r_w,
  ambeguity_code,
  represented_bases,
  coding,
  rw_col,
  multsh
)
}
\arguments{
\item{y}{numeric vector; entries in a cell corresponding
to a specific sample and a specific marker.}

\item{c_l}{string; marker label.}

\item{r_w}{numeric; sample ID's row number in the excel
file.}

\item{ambeguity_code}{string vector; ambeguity codes for
snp data.}

\item{represented_bases}{string vector; represented bases
for those ambeguity codes.}

\item{coding}{string; coding class of the molecular
marker.}

\item{rw_col}{string vector; variable used to switch
between row and column in case of transposed data.
Namely, \code{c("rows ", "row ", "column ", "columns
")}.}

\item{multsh}{string; reports warnings for multiple
worksheet datasets.}
}
\value{
a list of two elements: 1) a vector of
  represented bases on a marker corresponding to a sample
  in pre-specified coding class. 2) an identifier whose
  value is 1 if a warning takes place.
}
\description{
Translates the nucleotide ambiguity codes as
  defined in DNA Sequence Assembler from a pre-specified
  coding class to 4-letter codes.
}
\seealso{
For further details see: \code{\link{moimport}},
  \code{\link{moi_marker}} and
  \code{\link{corrector_string}}. See also the vignette
  'StandardAmbiguityCodes'.
}
\keyword{internal}
