% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCvis.R
\docType{package}
\name{MCMCvis-package}
\alias{MCMCvis}
\alias{MCMCvis-package}
\title{The 'MCMCvis' package}
\description{
`MCMCvis` is an R package used to visualize, manipulate, and summarize MCMC output. MCMC output may be derived from Bayesian model output fit with JAGS, Stan, or other MCMC samplers.
}
\section{Details}{

The following functions are currently available:

     -\code{MCMCsummary} - summarize MCMC output for particular parameters of interest

     -\code{MCMCpstr} - summarize MCMC output for particular parameters of interest while preserving original parameter structure

     -\code{MCMCtrace} - create trace and density plots of MCMC chains for particular parameters of interest

     -\code{MCMCchains} - easily extract posterior chains from MCMC output for particular parameters of interest

     -\code{MCMCplot} - create caterpillar plots from MCMC output for particular parameters of interest)

     -\code{MCMCdiag} - create a .txt file and save specified objects that summarize model inputs, outputs, and diagnostics

Example data can be loaded using \code{data(MCMC_data)}.

`MCMCvis` was designed to perform key functions for MCMC analysis using minimal code, in order to free up time/brainpower for interpretation of analysis results. Functions support simple and straightforward subsetting of model parameters within the calls, and produce presentable, 'publication-ready' output.

The vignette can be run using \code{vignette('MCMCvis')} if vignette is built when installing package.
}

\section{Author(s)}{

Casey Youngflesh <caseyyoungflesh@gmail.com>
Christian Che-Castaldo <chrischecastaldo@protonmail.com>
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/caseyyoungflesh/MCMCvis}
  \item Report bugs at \url{https://github.com/caseyyoungflesh/MCMCvis/issues}
}

}
\author{
\strong{Maintainer}: Casey Youngflesh \email{caseyyoungflesh@gmail.com} (\href{https://orcid.org/0000-0001-6343-3311}{ORCID})

Authors:
\itemize{
  \item Christian Che-Castaldo \email{christian.che-castaldo@stonybrook.edu} (\href{https://orcid.org/0000-0002-7670-2178}{ORCID})
}

Other contributors:
\itemize{
  \item Tyler Hardy [contributor]
}

}
