% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcm_lmer.R
\name{mcm_lmer}
\alias{mcm_lmer}
\title{Estimate and Test Inter-generational Mobility Effect
with Longitudinal Data}
\usage{
mcm_lmer(
  formula,
  data = NULL,
  REML = TRUE,
  control = lme4::lmerControl(),
  start = NULL,
  verbose = 0L,
  subset,
  weights,
  na.action,
  offset,
  contrasts = NULL,
  devFunOnly = FALSE,
  origin = NULL,
  destination = NULL,
  time = NULL,
  displayresult = TRUE,
  ...
)
}
\arguments{
\item{formula}{Inherit the function form from \code{lme4}
package. It is a two-sided linear formula
object describing both the fixed-effects and
random-effects part of the model, with the response
on the left of a \code{~} operator and the terms,
separated by + operators, on the right.
Random-effects terms are distinguished by vertical
bars (\code{|}) separating expressions for design
matrices from grouping factors.
Two vertical bars (\code{||}) can be used to specify
multiple uncorrelated random effects for the same
grouping variable. (Because of the way it is implemented,
the \code{||}-syntax works only for design matrices
containing numeric (continuous) predictors;
to fit models with independent categorical effects,
see dummy or the lmer_alt function from the \code{afex}
package.) A typical model used in studying social mobility with
longitudinal data
takes the form \code{response ~ origin*destination + | id}, where
\code{respose} is the numeric response vector and \code{origin}
(\code{destination}) is a vector indicating the origin (destination).
The specification of \code{origin*destination} indicates the cross of
\code{origin} and \code{destination}, which is the same as \code{
origin + destination + origin:destination} where
\code{origin:destination} indicates the interaction of \code{origin}
and \code{destination}. \code{id} is a identifier for the clusters.}

\item{data}{an optional data frame, list or environment
(or object coercible by as.data.frame to a data frame)
containing the variables in the model. If not found in data,
the variables are taken from environment(formula),
typically the environment from which the function is called.}

\item{REML}{logical. Should the estimates be chosen be optimize the
restricted log-likelihood (REML) criterial (as opposed to the
log-likelihood)?}

\item{control}{Inherit from \code{lme4} package. It is a list (of correct
class, resulting from lmerControl() or glmerControl() respectively)
containing control parameters, including the nonlinear optimizer to
be used and parameters to be passed through to the nonlinear optimizer,
see the \code{lmerControl} documentation in \code{lme4} package for details.}

\item{start}{Inherit from \code{lme4} package. It is a named list of
starting values for the parameters in the model.}

\item{verbose}{Inherit from \code{lme4} package. It is an integer scalar.
If > 0 verbose output is generated during the optimization of the parameter
estimates. If > 1 verbose output is generated during the individual
penalized iteratively reweighted least squares (PIRLS) steps.}

\item{subset}{optional expression selecting the subset of the rows of data
to fit the model.}

\item{weights}{an optional vector of ‘prior weights’ to
be used in the fitting process.
Should be NULL or a numeric vector.}

\item{na.action}{a function which indicates what should
happen when the data contain NAs.The default is set by the
\code{na.action} setting in \code{options} and is
\code{na.fail} if that is unset.}

\item{offset}{Inherit from \code{lme4} package. This can be used
to specify an a priori known component to be included in the linear
predictor during fitting. This should be NULL or a numeric vector
of length equal to the number of cases. One or more offset
terms can be included in the formula instead or as well,
and if more than one is specified their sum is used.}

\item{contrasts}{an optional list. The default is set as sum-to-zero
contrast.}

\item{devFunOnly}{logical - return only the deviance evaluation function.}

\item{origin}{a character indicating the column name of origin.}

\item{destination}{a character indicating the column name of destination.}

\item{time}{a character indicating the time when individual was observed}

\item{displayresult}{logical. Should model results be displayed
after estimation. The default is \code{TRUE}.}

\item{\dots}{additional arguments to be passed to the function.}
}
\value{
A list containing:
\item{model}{Fitted generalized models of outcome on predictors.
See more on function \code{glm} in package \code{stats}.}
\item{estimates}{Estimated mobility effects.}
\item{se}{Standard errors of the estimated mobility effects.}
\item{significance}{Statistical significance of the the
estimated mobility effects.}
\item{esti_3way}{Estimated mobility effects conditional
on specific age.}
\item{se_3way}{Standard errors of the estimated mobility
effects conditional specific age.}
\item{sig_3way}{Statistical significance of the the
estimated mobility effects conditional on age.}
}
\description{
This function fits a multilevel mobility contrast model
to estimate and test inter-generational mobility effect
on an outcome in longitudinal data.
}
\examples{
library(MCM)
library(lme4)
data("sim_datlmer")
fit_mcm_lmer <- mcm_lmer(yij ~ origin*destination*age +
                           (1|id), data = sim_datlmer,
                         origin = "origin",
                         destination = "destination",
                         time = "age")


}
