% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConfusionMarix.r
\name{ConfusionMatrix}
\alias{ConfusionMatrix}
\title{Confusion matrix}
\usage{
ConfusionMatrix(y_true, y_pred)
}
\arguments{
\item{y_true}{True labels}

\item{y_pred}{Predicted labels}
}
\value{
A data frame
}
\description{
A function to calculate the confusion matrix of the machine and deep learning models. It outputs Accuracy, Precision, Sensitivity, F1-Score, Specificity, and AUC_average.
}
\examples{
set.seed(1234)
data <- Data1[1:10,]
data$subgroup <- factor(data$subgroup)
fac <- ncol(data)
split <- caTools::sample.split(data[, fac], SplitRatio = 0.8)
training_set <- subset(data, split == TRUE)
test_set <- subset(data, split == FALSE)
rf <- randomForest::randomForest(x = training_set[-fac],
                                 y = training_set[, fac],
                                 ntree = 10)
y_pred <- predict(rf, newdata = test_set[-fac])
ConfusionMatrix(y_true = test_set[, fac],
                y_pred = y_pred)
}
