% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.MBPCA.R
\name{summary.MBPCA}
\alias{summary.MBPCA}
\title{Summary Results for Multiblock Principal Components Analysis (MB-PCA)}
\usage{
\method{summary}{MBPCA}(object, nvar = NULL, ncompprint = NULL, digits = 2, ...)
}
\arguments{
\item{object}{An object of class \code{MBPCA}.}

\item{nvar}{Number of variables to print. By default (NULL), all the variables are printed.}

\item{ncompprint}{Number of global components to print. By default (NULL), the number of global components printed for the main function MBPCA.}

\item{digits}{Number of decimal points (by default 2).}

\item{...}{Further arguments.}
}
\value{
Returns the percentages of inertia explained by successive global components, their cumulative values
and the correlations of the original variables with the global components.
}
\description{
Gives key results for MB-PCA.
}
\examples{
data(ham)
X=ham$X
group=ham$group
res.mbpca <- MBPCA(X, group, plotgraph=FALSE)
summary(res.mbpca)
}
\seealso{
\code{\link{MBPCA}}
}
\author{
Essomanda TCHANDAO MANGAMANA \email{tchanesso@yahoo.fr}, Véronique CARIOU, Evelyne VIGNEAU.
}
