% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAVE_CV.R
\name{mave.dim}
\alias{mave.dim}
\title{Select best direction using cross-validation}
\usage{
mave.dim(dr, max.dim = 10)
}
\arguments{
\item{dr}{the result of MAVE function}

\item{max.dim}{the maximum dimension for cross-validation.}
}
\value{
dr.dim contains all information in dr plus cross-validation values of corresponding
direction
}
\description{
This function selects the dimension of the central (mean)  space
based on the calculation of MAVE  using cross-validation method.
}
\examples{
 x <- matrix(rnorm(400*5),400,5)
 b1 <- matrix(c(1,1,0,0,0),5,1)
 b2 <- matrix(c(0,0,1,1,0),5,1)
 eps <- matrix(rnorm(400),400,1)
 y <- x\%*\%b1 + (x\%*\%b2)*eps

 #seleted dimension of central space
 dr.cs <- mave(y~x,method='csmave')
 dr.cs.dim <- mave.dim(dr.cs)

 #seleted dimension of central mean space
 dr.mean <- mave(y~x,method='meanmave')
 dr.mean.dim <- mave.dim(dr.mean)
}

