% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_10_ADHOC_PLOT_2_PlotValues_Gene.R
\name{PlotValues.Exp}
\alias{PlotValues.Exp}
\title{Plot gene expression values}
\usage{
PlotValues.Exp(
  MarvelObject,
  cell.group.list,
  feature,
  maintitle = "gene_short_name",
  xlabels.size = 8,
  cell.group.colors = NULL,
  point.alpha = 0.2
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{TransformExpValues} function.}

\item{cell.group.list}{List of character strings. Each element of the list is a vector of cell IDs corresponding to a cell group. The name of the element will be the cell group label.}

\item{feature}{Character string. \code{gene_id} for plotting. Should match \code{gene_id} column of \code{MarvelObject$GeneFeature} slot.}

\item{maintitle}{Character string. Column to use as plot main title as per \code{MarvelObject$GeneFeature}. Default is \code{"gene_short_name"} column.}

\item{xlabels.size}{Numeric value. Size of x-axis labels as per \code{ggplot2} function. Default is 8.}

\item{cell.group.colors}{Character string. Vector of colors for the cell groups specified for PCA analysis using \code{cell.type.columns}, \code{cell.type.variable}, and \code{cell.type.labels}. If not specified, default \code{ggplot2} colors will be used.}

\item{point.alpha}{Numeric value. Transparency of the data points. Takes any values between 0-1. Default value is \code{0.2}.}
}
\value{
An object of class S3 with new slot \code{MarvelObject$adhocPlot$Exp}.
}
\description{
Boxplot of gene expression values across different groups of cells.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

df.pheno <- marvel.demo$SplicePheno
cell.group.g1 <- df.pheno[which(df.pheno$cell.type=="iPSC"), "sample.id"]
cell.group.g2 <- df.pheno[which(df.pheno$cell.type=="Endoderm"), "sample.id"]
cell.group.list <- list(cell.group.g1, cell.group.g2)
names(cell.group.list) <- c("iPSC", "Endoderm")

# Plot
marvel.demo <- PlotValues.Exp(MarvelObject=marvel.demo,
                              cell.group.list=cell.group.list,
                              feature="ENSG00000161970.15",
                              xlabels.size=8
                              )

# Check output
marvel.demo$adhocPlot$Exp
}
