% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_RLum.R
\name{methods_RLum}
\alias{methods_RLum}
\alias{plot.list}
\alias{plot.RLum.Results}
\alias{plot.RLum.Analysis}
\alias{plot.RLum.Data.Curve}
\alias{plot.RLum.Data.Spectrum}
\alias{plot.RLum.Data.Image}
\alias{plot.Risoe.BINfileData}
\alias{hist.RLum.Results}
\alias{hist.RLum.Data.Image}
\alias{hist.RLum.Data.Curve}
\alias{hist.RLum.Analysis}
\alias{summary.RLum.Results}
\alias{summary.RLum.Analysis}
\alias{summary.RLum.Data.Image}
\alias{summary.RLum.Data.Curve}
\alias{subset.Risoe.BINfileData}
\alias{subset.RLum.Analysis}
\alias{bin.RLum.Data.Curve}
\alias{bin.RLum.Data.Spectrum}
\alias{length.RLum.Results}
\alias{length.RLum.Analysis}
\alias{length.RLum.Data.Curve}
\alias{length.Risoe.BINfileData}
\alias{dim.RLum.Data.Curve}
\alias{dim.RLum.Data.Spectrum}
\alias{rep.RLum}
\alias{names.RLum.Data.Curve}
\alias{names.RLum.Data.Spectrum}
\alias{names.RLum.Data.Image}
\alias{names.RLum.Analysis}
\alias{names.RLum.Results}
\alias{names.Risoe.BINfileData}
\alias{row.names.RLum.Data.Spectrum}
\alias{as.data.frame.RLum.Data.Curve}
\alias{as.data.frame.RLum.Data.Spectrum}
\alias{as.list.RLum.Results}
\alias{as.list.RLum.Data.Curve}
\alias{as.list.RLum.Analysis}
\alias{as.matrix.RLum.Data.Curve}
\alias{as.matrix.RLum.Data.Spectrum}
\alias{is.RLum}
\alias{is.RLum.Data}
\alias{is.RLum.Data.Curve}
\alias{is.RLum.Data.Spectrum}
\alias{is.RLum.Data.Image}
\alias{is.RLum.Analysis}
\alias{is.RLum.Results}
\alias{merge.RLum}
\alias{unlist.RLum.Analysis}
\alias{+.RLum.Data.Curve}
\alias{-.RLum.Data.Curve}
\alias{*.RLum.Data.Curve}
\alias{/.RLum.Data.Curve}
\alias{[.RLum.Data.Curve}
\alias{[.RLum.Data.Spectrum}
\alias{[.RLum.Data.Image}
\alias{[.RLum.Analysis}
\alias{[.RLum.Results}
\alias{[<-.RLum.Data.Curve}
\alias{[[.RLum.Analysis}
\alias{[[.RLum.Results}
\alias{$.RLum.Data.Curve}
\alias{$.RLum.Analysis}
\alias{$.RLum.Results}
\title{methods_RLum}
\usage{
\method{plot}{list}(x, y, ...)

\method{plot}{RLum.Results}(x, y, ...)

\method{plot}{RLum.Analysis}(x, y, ...)

\method{plot}{RLum.Data.Curve}(x, y, ...)

\method{plot}{RLum.Data.Spectrum}(x, y, ...)

\method{plot}{RLum.Data.Image}(x, y, ...)

\method{plot}{Risoe.BINfileData}(x, y, ...)

\method{hist}{RLum.Results}(x, ...)

\method{hist}{RLum.Data.Image}(x, ...)

\method{hist}{RLum.Data.Curve}(x, ...)

\method{hist}{RLum.Analysis}(x, ...)

\method{summary}{RLum.Results}(object, ...)

\method{summary}{RLum.Analysis}(object, ...)

\method{summary}{RLum.Data.Image}(object, ...)

\method{summary}{RLum.Data.Curve}(object, ...)

\method{subset}{Risoe.BINfileData}(x, subset, records.rm = TRUE, ...)

\method{subset}{RLum.Analysis}(x, subset = NULL, ...)

bin.RLum.Data.Curve(x, bin_size = 2, ...)

bin.RLum.Data.Spectrum(x, bin_size.row = 1, bin_size.col = 1, ...)

\method{length}{RLum.Results}(x, ...)

\method{length}{RLum.Analysis}(x, ...)

\method{length}{RLum.Data.Curve}(x, ...)

\method{length}{Risoe.BINfileData}(x, ...)

\method{dim}{RLum.Data.Curve}(x)

\method{dim}{RLum.Data.Spectrum}(x)

\method{rep}{RLum}(x, ...)

\method{names}{RLum.Data.Curve}(x, ...)

\method{names}{RLum.Data.Spectrum}(x, ...)

\method{names}{RLum.Data.Image}(x, ...)

\method{names}{RLum.Analysis}(x, ...)

\method{names}{RLum.Results}(x, ...)

\method{names}{Risoe.BINfileData}(x)

\method{row.names}{RLum.Data.Spectrum}(x, ...)

\method{as.data.frame}{RLum.Data.Curve}(x, row.names = NULL, optional = FALSE, ...)

\method{as.data.frame}{RLum.Data.Spectrum}(x, row.names = NULL, optional = FALSE, ...)

\method{as.list}{RLum.Results}(x, ...)

\method{as.list}{RLum.Data.Curve}(x, ...)

\method{as.list}{RLum.Analysis}(x, ...)

\method{as.matrix}{RLum.Data.Curve}(x, ...)

\method{as.matrix}{RLum.Data.Spectrum}(x, ...)

is.RLum(x, ...)

is.RLum.Data(x, ...)

is.RLum.Data.Curve(x, ...)

is.RLum.Data.Spectrum(x, ...)

is.RLum.Data.Image(x, ...)

is.RLum.Analysis(x, ...)

is.RLum.Results(x, ...)

\method{merge}{RLum}(x, y, ...)

\method{unlist}{RLum.Analysis}(x, recursive = TRUE, ...)

\method{+}{RLum.Data.Curve}(x, y)

\method{-}{RLum.Data.Curve}(x, y)

\method{*}{RLum.Data.Curve}(x, y)

\method{/}{RLum.Data.Curve}(x, y)

\method{[}{RLum.Data.Curve}(x, y, z, drop = TRUE)

\method{[}{RLum.Data.Spectrum}(x, y, z, drop = TRUE)

\method{[}{RLum.Data.Image}(x, y, z, drop = TRUE)

\method{[}{RLum.Analysis}(x, i, drop = FALSE)

\method{[}{RLum.Results}(x, i, drop = TRUE)

\method{[}{RLum.Data.Curve}(x, i, j) <- value

\method{[[}{RLum.Analysis}(x, i)

\method{[[}{RLum.Results}(x, i)

\method{$}{RLum.Data.Curve}(x, i)

\method{$}{RLum.Analysis}(x, i)

\method{$}{RLum.Results}(x, i)
}
\arguments{
\item{x}{\linkS4class{RLum} or \linkS4class{Risoe.BINfileData} (\strong{required}):
input opject}

\item{y}{\link{integer} (\emph{optional}):
the row index of the matrix, data.frame}

\item{...}{further arguments that can be passed to the method}

\item{object}{\linkS4class{RLum} (\strong{required}):
input opject}

\item{subset}{\verb{[subset]} \link{expression} (\strong{required}):
logical expression indicating elements or rows to keep, this function works
in \linkS4class{Risoe.BINfileData} objects like \link{subset.data.frame}, but takes care
of the object structure}

\item{records.rm}{\link{subset} \link{logical} (\emph{with default}):
remove records from data set, can be disabled, to just set the column \code{SET} to \code{TRUE} or \code{FALSE}}

\item{row.names}{\link{logical} (\emph{with default}):
enables or disables row names (\code{as.data.frame})}

\item{optional}{\link{logical} (\emph{with default}):
logical. If TRUE, setting row names and converting column names
(to syntactic names: see make.names) is optional (see \link[base:as.data.frame]{base::as.data.frame})}

\item{recursive}{\link{logical} (\emph{with default}):
enables or disables further subsetting (\code{unlist})}

\item{z}{\link{integer} (\emph{optional}):
the column index of the matrix, data.frame}

\item{drop}{\link{logical} (\emph{with default}):
keep object structure or drop it}

\item{i}{\link{character} (\emph{optional}):
name of the wanted record type or data object or row in the \code{RLum.Data.Curve} object}

\item{j}{\link{integer} (\emph{optional}):
column of the data matrix in the \code{RLum.Data.Curve} object}

\item{value}{\link{numeric} \strong{(required)}:
numeric value which replace the value in the \code{RLum.Data.Curve} object}
}
\description{
Methods for S3-generics implemented for the package 'Luminescence'.
This document summarises all implemented S3-generics. The name of the function
is given before the first dot, after the dot the name of the object that is
supported by this method is given, e.g. \code{plot.RLum.Data.Curve} can be called
by \code{plot(object, ...)}, where \code{object} is the \code{RLum.Data.Curve} object.
}
\details{
The term S3-generics sounds complicated, however, it just means that something
has been implemented in the package to increase the usability for users new
in R and who are not familiar with the underlying \code{RLum}-object structure of
the package. The practical outcome is that operations and functions presented
in standard books on R can be used without knowing the specifica of the R
package 'Luminescence'. For examples see the example section.
}
\note{
\code{methods_RLum} are not really new functions, everything given here are mostly just
surrogates for existing functions in the package.
}
\examples{

##load example data
data(ExampleData.RLum.Analysis, envir = environment())


##combine curve is various ways
curve1 <- IRSAR.RF.Data[[1]]
curve2 <-  IRSAR.RF.Data[[1]]
curve1 + curve2
curve1 - curve2
curve1 / curve2
curve1 * curve2


##`$` access curves
IRSAR.RF.Data$RF

}
\keyword{internal}
