% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_RLum.Results.R
\name{merge_RLum.Results}
\alias{merge_RLum.Results}
\title{Merge function for RLum.Results S4-class objects}
\usage{
merge_RLum.Results(objects)
}
\arguments{
\item{objects}{\link{list} (\strong{required}):
a list of \linkS4class{RLum.Results} objects}
}
\description{
Function merges objects of class \linkS4class{RLum.Results}. The slots in the objects
are combined depending on the object type, e.g., for \link{data.frame} and \link{matrix}
rows are appended.
}
\details{
Elements are appended where possible and attributes are preserved if
not of similar name as the default attributes of, e.g., a \link{data.frame}
}
\note{
The \code{originator} is taken from the first element and not reset to \code{merge_RLum}
}
\section{Function version}{
 0.2.1
}

\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2024. merge_RLum.Results(): Merge function for RLum.Results S4-class objects. Function version 0.2.1. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., 2024. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.25. https://r-lum.github.io/Luminescence/
}

\keyword{internal}
