% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_KDE.R
\name{plot_KDE}
\alias{plot_KDE}
\title{Plot kernel density estimate with statistics}
\usage{
plot_KDE(
  data,
  na.rm = TRUE,
  values.cumulative = TRUE,
  order = TRUE,
  boxplot = TRUE,
  rug = TRUE,
  summary,
  summary.pos,
  summary.method = "MCM",
  bw = "nrd0",
  output = TRUE,
  ...
)
}
\arguments{
\item{data}{\link{data.frame} or \linkS4class{RLum.Results} object (\strong{required}):
for \code{data.frame}: two columns: De (\code{values[,1]}) and De error (\code{values[,2]}).
For plotting multiple data sets, these must be provided as
\code{list} (e.g. \code{list(dataset1, dataset2)}).}

\item{na.rm}{\link{logical} (\emph{with default}):
exclude NA values from the data set prior to any further operation.}

\item{values.cumulative}{\link{logical} (\emph{with default}):
show cumulative individual data.}

\item{order}{\link{logical}:
Order data in ascending order.}

\item{boxplot}{\link{logical} (\emph{with default}):
optionally show a boxplot (depicting median as thick central line,
first and third quartile as box limits, whiskers denoting +/- 1.5
interquartile ranges and dots further outliers).}

\item{rug}{\link{logical} (\emph{with default}):
optionally add rug.}

\item{summary}{\link{character} (\emph{optional}):
add statistic measures of centrality and dispersion to the plot. Can be one
or more of several keywords. See details for available keywords.}

\item{summary.pos}{\link{numeric} or \link{character} (\emph{with default}):
optional position coordinates or keyword (e.g. \code{"topright"})
for the statistical summary. Alternatively, the keyword \code{"sub"} may be
specified to place the summary below the plot header. However, this latter
option in only possible if \code{mtext} is not used. In case of coordinate
specification, y-coordinate refers to the right y-axis.}

\item{summary.method}{\link{character} (\emph{with default}):
keyword indicating the method used to calculate the statistic summary.
One out of \code{"unweighted"}, \code{"weighted"} and \code{"MCM"}.
See \link{calc_Statistics} for details.}

\item{bw}{\link{character} (\emph{with default}):
bin-width, chose a numeric value for manual setting.}

\item{output}{\link{logical}:
Optional output of numerical plot parameters. These can be useful to
reproduce similar plots. Default is \code{TRUE}.}

\item{...}{further arguments and graphical parameters passed to \link{plot}.}
}
\description{
Plot a kernel density estimate of measurement values in combination with the
actual values and associated error bars in ascending order. If enabled, the
boxplot will show the usual distribution parameters (median as
bold line, box delimited by the first and third quartile, whiskers defined
by the extremes and outliers shown as points) and also the mean and
standard deviation as pale bold line and pale polygon, respectively.
}
\details{
The function allows passing several plot arguments, such as \code{main},
\code{xlab}, \code{cex}. However, as the figure is an overlay of two
separate plots, \code{ylim} must be specified in the order: c(ymin_axis1,
ymax_axis1, ymin_axis2, ymax_axis2) when using the cumulative values plot
option. See examples for some further explanations. For details on the
calculation of the bin-width (parameter \code{bw}) see
\link{density}.

A statistic summary, i.e. a collection of statistic measures of
centrality and dispersion (and further measures) can be added by specifying
one or more of the following keywords:
\itemize{
\item \code{"n"} (number of samples)
\item \code{"mean"} (mean De value)
\item \code{"median"} (median of the De values)
\item \code{"sd.rel"} (relative standard deviation in percent)
\item \code{"sd.abs"} (absolute standard deviation)
\item \code{"se.rel"} (relative standard error)
\item \code{"se.abs"} (absolute standard error)
\item \code{"in.2s"} (percent of samples in 2-sigma range)
\item \code{"kurtosis"} (kurtosis)
\item \code{"skewness"} (skewness)
}

\strong{Note} that the input data for the statistic summary is sent to the function
\code{calc_Statistics()} depending on the log-option for the z-scale. If
\code{"log.z = TRUE"}, the summary is based on the logarithms of the input
data. If \code{"log.z = FALSE"} the linearly scaled data is used.

\strong{Note} as well, that \code{"calc_Statistics()"} calculates these statistic
measures in three different ways: \code{unweighted}, \code{weighted} and
\code{MCM-based} (i.e., based on Monte Carlo Methods). By default, the
MCM-based version is used. If you wish to use another method, indicate this
with the appropriate keyword using the argument \code{summary.method}.
}
\note{
The plot output is no 'probability density' plot (cf. the discussion
of Berger and Galbraith in Ancient TL; see references)!
}
\section{Function version}{
 3.6.0
}

\examples{

## read example data set
data(ExampleData.DeValues, envir = environment())
ExampleData.DeValues <-
  Second2Gray(ExampleData.DeValues$BT998, c(0.0438,0.0019))

## create plot straightforward
plot_KDE(data = ExampleData.DeValues)

## create plot with logarithmic x-axis
plot_KDE(data = ExampleData.DeValues,
         log = "x")

## create plot with user-defined labels and axes limits
plot_KDE(data = ExampleData.DeValues,
         main = "Dose distribution",
         xlab = "Dose (s)",
         ylab = c("KDE estimate", "Cumulative dose value"),
         xlim = c(100, 250),
         ylim = c(0, 0.08, 0, 30))

## create plot with boxplot option
plot_KDE(data = ExampleData.DeValues,
         boxplot = TRUE)

## create plot with statistical summary below header
plot_KDE(data = ExampleData.DeValues,
         summary = c("n", "median", "skewness", "in.2s"))

## create plot with statistical summary as legend
plot_KDE(data = ExampleData.DeValues,
         summary = c("n", "mean", "sd.rel", "se.abs"),
         summary.pos = "topleft")

## split data set into sub-groups, one is manipulated, and merge again
data.1 <- ExampleData.DeValues[1:15,]
data.2 <- ExampleData.DeValues[16:25,] * 1.3
data.3 <- list(data.1, data.2)

## create plot with two subsets straightforward
plot_KDE(data = data.3)

## create plot with two subsets and summary legend at user coordinates
plot_KDE(data = data.3,
         summary = c("n", "median", "skewness"),
         summary.pos = c(110, 0.07),
         col = c("blue", "orange"))

## example of how to use the numerical output of the function
## return plot output to draw a thicker KDE line
KDE_out <- plot_KDE(data = ExampleData.DeValues,
output = TRUE)

}
\seealso{
\link{density}, \link{plot}
}
\author{
Michael Dietze, GFZ Potsdam (Germany)\cr
Geography & Earth Sciences, Aberystwyth University (United Kingdom)
, RLum Developer Team} 

\section{How to cite}{
Dietze, M., 2022. plot_KDE(): Plot kernel density estimate with statistics. Function version 3.6.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2022. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.17. https://CRAN.R-project.org/package=Luminescence
}

