% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_RLum.R
\name{set_RLum}
\alias{set_RLum}
\alias{set_RLum.Analysis}
\alias{set_RLum.Data.Curve}
\alias{set_RLum.Data.Image}
\alias{set_RLum.Data.Spectrum}
\alias{set_RLum.Results}
\title{General set function for RLum S4 class objects}
\usage{
set_RLum(class, originator, ...)
}
\arguments{
\item{class}{\code{\linkS4class{RLum}} (\bold{required}): name of the S4 class to
create}

\item{originator}{\code{\link{character}} (automatic): contains the name of the calling function
(the function that produces this object); can be set manually.}

\item{\dots}{further arguments that one might want to pass to the specific
set method}
}
\value{
Returns an object of the specified class.
}
\description{
Function calls object-specific set functions for RLum S4 class objects.
}
\details{
The function provides a generalised access point for specific
\code{\linkS4class{RLum}} objects.\cr Depending on the given class, the
corresponding method to create an object from this class will be selected.
Allowed additional arguments can be found in the documentations of the
corresponding \code{\linkS4class{RLum}} class: \code{\linkS4class{RLum.Data.Curve}},
\code{\linkS4class{RLum.Data.Image}}, \code{\linkS4class{RLum.Data.Spectrum}},
\code{\linkS4class{RLum.Analysis}} and \code{\linkS4class{RLum.Results}}
}
\section{Function version}{
 0.2.0 (2015-12-06 23:16:02)
}
\examples{

##produce empty objects from each class
set_RLum(class = "RLum.Data.Curve")
set_RLum(class = "RLum.Data.Spectrum")
set_RLum(class = "RLum.Data.Spectrum")
set_RLum(class = "RLum.Analysis")
set_RLum(class = "RLum.Results")

##produce a curve object with arbitrary curve values
object <- set_RLum(
class = "RLum.Data.Curve",
curveType = "arbitrary",
recordType = "OSL",
data = matrix(c(1:100,exp(-c(1:100))),ncol = 2))

##plot this curve object
plot_RLum(object)

}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
\cr R Luminescence Package Team}
\seealso{
\code{\linkS4class{RLum.Data.Curve}},
\code{\linkS4class{RLum.Data.Image}},
\code{\linkS4class{RLum.Data.Spectrum}},
\code{\linkS4class{RLum.Analysis}},
\code{\linkS4class{RLum.Results}}
}
\keyword{utilities}

