% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Risoe.BINfileData2RLum.Analysis.R
\name{Risoe.BINfileData2RLum.Analysis}
\alias{Risoe.BINfileData2RLum.Analysis}
\title{Convert Risoe.BINfileData object to an RLum.Analysis object}
\usage{
Risoe.BINfileData2RLum.Analysis(object, pos, run, set, ltype,
  protocol = "unknown")
}
\arguments{
\item{object}{\code{\linkS4class{Risoe.BINfileData}} (\bold{required}):
\code{Risoe.BINfileData} object}

\item{pos}{\code{\link{integer}} (\bold{required}): position number of the
\code{Risoe.BINfileData} object for which the curves are stored in the
\code{RLum.Analysis} object. If the position is not valid \code{NA} is
returned.}

\item{run}{\code{\link{vector}, \link{numeric}} (optional): run number from
the measurement to limit the converted data set (e.g., \code{run =
c(1:48)}).}

\item{set}{\code{\link{vector}, \link{numeric}} (optional): set number from
the measurement to limit the converted data set (e.g., \code{set =
c(1:48)}).}

\item{ltype}{\code{\link{vector}, \link{character}} (optional): curve type
to limit the converted data. Allowed values are: \code{IRSL}, \code{OSL},
\code{TL}, \code{RIR}, \code{RBR} and \code{USER}}

\item{protocol}{\code{\link{character}} (optional): sets protocol type for
analysis object. Value may be used by subsequent analysis functions.}
}
\value{
Returns an \code{\linkS4class{RLum.Analysis}} object.
}
\description{
Converts values from one specific position of a Risoe.BINfileData S4-class
object to an RLum.Analysis object.
}
\details{
The \code{\linkS4class{RLum.Analysis}} object requires a set of curves for
specific further protocol analyses. However, the
\code{\linkS4class{Risoe.BINfileData}} usually contains a set of curves for
different aliquots and different protocol types that may be mixed up.
Therefore, a conversion is needed.
}
\note{
The \code{protocol} argument of the \code{\linkS4class{RLum.Analysis}}
object is set to 'unknown' if not stated otherwise.
}
\section{Function version}{
 0.1.2 (2015-07-23 17:09:29)
}
\examples{
##load data
data(ExampleData.BINfileData, envir = environment())

##convert values for position 1
Risoe.BINfileData2RLum.Analysis(CWOSL.SAR.Data, pos = 1)
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
\cr R Luminescence Package Team}
\references{
#
}
\seealso{
\code{\linkS4class{Risoe.BINfileData}},
\code{\linkS4class{RLum.Analysis}}, \code{\link{readBIN2R}}
}
\keyword{manip}

