% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSE.R
\name{G.hat}
\alias{G.hat}
\title{Estimation of G matrix for multivariate long memory processes.}
\usage{
G.hat(X, d, m)
}
\arguments{
\item{X}{data matrix with T observations of q-dimensional process.}

\item{d}{q-dimensional data vector.}

\item{m}{bandwith parameter specifying the number of Fourier frequencies.
used for the estimation usually \code{floor(1+T^delta)}, where 0<delta<1.}
}
\description{
\code{G.hat} Estimates the matrix G of a multivariate long memory process 
             based on an estimate of the vector of memory parameters. The assumed spectral 
             density is that of Shimotsu (2007).
}
\examples{
T<-500
d1<-0.4
d2<-0.2
data<-FI.sim(T, q=2, rho=0, d=c(d1,d2))
G.hat(X=data, d=c(d1,d2), m=floor(1+T^0.6))
#diagonal elements should equal 1/(2*pi)
}
\references{
Shimotsu, K. (2007): Gaussian semiparametric estimation of multivariate
fractionally integrated processes. Journal of Econometrics, Vol. 137, No. 2, pp. 277 - 310.
}
