% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lock5withR-package.R
\docType{data}
\name{ICUAdmissions}
\alias{ICUAdmissions}
\title{Intensive Care Unit Admissions}
\format{A data frame with 200 observations on the following 21 variables.
\itemize{ 
   \item{\code{ID}} {Patient ID number}

   \item{\code{status}} {Patient status: \code{Lived} or \code{Died}}
   \item{\code{Status}} {numerical code for \code{Status}}

   \item{\code{Age}} {Patient's age (in years)}

   \item{\code{sex}} {\code{Male} or \code{Female}}
   \item{\code{Sex}} {numerical code for \code{sex}}

   \item{\code{race}} {Patient's race: \code{White}, \code{Black}, or
\code{Other} }
   \item{\code{Race}} {numerical code for \code{race}}
   \item{\code{service}} {Type of service: \code{Medical} or
\code{Surgical} }
   \item{\code{Service}} {numerical code for \code{service}}
   \item{\code{cancer}} {Is cancer involved?  \code{No} or \code{Yes}}
   \item{\code{Cancer}} {Is cancer involved?  \code{0} or \code{1}}
   \item{\code{renal}} {Is chronic renal failure involved? \code{No} or \code{Yes}} 
   \item{\code{Renal}} {Is chronic renal failure involved? \code{0} or \code{1}} 
   \item{\code{infection}} {Is infection involved? \code{No} or \code{Yes}}
   \item{\code{Infection}} {Is infection involved? \code{0} or \code{1}}
   \item{\code{cpr}} {Patient gets CPR prior to admission? \code{No} or \code{Yes}}
   \item{\code{CPR}} {Patient gets CPR prior to admission? \code{0} or \code{1}}
   \item{\code{Systolic}} {Systolic blood pressure (in mm of Hg)} 
   \item{\code{HeartRate}} {Pulse rate (beats per minute)} 
   \item{\code{previous}} {Previous admission to ICU wihtin 6 months? \code{No} or \code{Yes}}
   \item{\code{Previous}} {Previous admission to ICU wihtin 6 months? \code{0} or \code{1}}
   \item{\code{type}} {Admission type: \code{Elective} or \code{Emergency}}
   \item{\code{Type}} {Admission type: \code{0} or \code{1}}
   \item{\code{fracture}} {Fractured bone involved? \code{No} or \code{Yes}}
   \item{\code{Fracture}} {Fractured bone involved? \code{0} or \code{1}}
   \item{\code{pO2}} {Partial oxygen level from blood gases under 60? 
                     \code{No} or  \code{Yes}}
   \item{\code{PO2}} {Partial oxygen level from blood gases under 60? 
                     \code{0} or  \code{1}}
   \item{\code{pHlow}} {pH from blood gas under 7.25? \code{No} or \code{Yes}}
   \item{\code{pH}} {pH from blood gas under or over 7.25? \code{Low} or \code{Hi}}
   \item{\code{PH}} {pH from blood gas under or over 7.25? \code{0} or \code{1}}
   \item{\code{pCO2hi}} {Partial carbon dioxide level from blood gas over 45?
               \code{No} or \code{Yes}}
   \item{\code{pCO2}} {Partial carbon dioxide level from blood gas over or under 45?
               \code{Low} or \code{Hi}}
   \item{\code{PCO2}} {Partial carbon dioxide level from blood gas over or under 45?
               \code{0} or \code{1}}
   \item{\code{bicarbonateLow}} {Bicarbonate from
blood gas under 18? \code{No} or \code{Yes}}
   \item{\code{bicarbonate}} {Bicarbonate from
blood gas under or over 18? \code{Low} or \code{Hi}}
   \item{\code{Bicarbonate}} {Bicarbonate from
blood gas under or over 18? \code{0} or \code{1}}
   \item{\code{creatinineHi}} {Creatinine from blood gas over 2.0? 
         \code{No} or \code{Yes}}
   \item{\code{creatinine}} {Creatinine from blood gas over or under 2.0? 
         \code{Low} or \code{Hi}}
   \item{\code{Creatinine}} {Creatinine from blood gas over or under 2.0? 
         \code{0} or \code{1}}
   \item{\code{consciousness}} {Levels: \code{Conscious}, \code{Deep Stupor}, or \code{Coma}}
   \item{\code{Consciousness}} {Levels: \code{0}, \code{1}, or \code{2}}
   }}
\source{
DASL dataset downloaded from
\url{http://lib.stat.cmu.edu/DASL/Datafiles/ICU.html}
}
\description{
data from patients admitted to an intensive care unit
}
\details{
Data from a sample of 200 patients following admission to an adult intensive
care unit (ICU).
}
\examples{

data(ICUAdmissions)

}
\keyword{datasets}

