% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localControl.R
\name{plot.LocalControlCR}
\alias{plot.LocalControlCR}
\title{Plot cumulative incidence functions (CIFs) from Local Control.}
\usage{
\method{plot}{LocalControlCR}(x, ..., rad2plot, xlim, ylim = c(0, 1),
  col1 = "blue", col0 = "red", xlab = "Time",
  ylab = "Cumulative incidence", legendLocation = "topleft", main = "",
  group1 = "Treatment 1", group0 = "Treatment 0")
}
\arguments{
\item{x}{Return object from LocalControl with outcomeType = "survival".}

\item{...}{Arguments passed on to \code{graphics::plot}
\describe{
  \item{}{}
}}

\item{rad2plot}{The index or name ("rad_#") of the radius to plot. By default, the radius with pct_informative closest to
0.8 will be selected.}

\item{xlim}{The x axis bounds. Defaults to c(0, max(lccrResults$Failtimes)).}

\item{ylim}{The y axis bounds. Defaults to c(0,1).}

\item{col1}{The plot color for group 1.}

\item{col0}{The plot color for group 0.}

\item{xlab}{The x axis label. Defaults to "Time".}

\item{ylab}{The y axis label. Defaults to "Cumulative incidence".}

\item{legendLocation}{The location to place the legend. Default "topleft".}

\item{main}{The main plot title. Default is empty.}

\item{group1}{The name of the primary group (Treatment 1).}

\item{group0}{The name of the secondary group (Treatment 0).}
}
\description{
Given the results from LocalControl with outcomeType = "survival",
  plot a corrected and uncorrected cumulative incidence function (CIF) for both groups.
}
\examples{
data("cardSim")
results = LocalControl(data = cardSim,
                       outcomeType = "survival",
                       outcomeColName = "status",
                       timeColName = "time",
                       treatmentColName = "drug",
                       treatmentCode = 1,
                       clusterVars = c("age", "bmi"))
plot(results)

}
