% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_plots.R
\name{LoTTA_plot_effect_CONT}
\alias{LoTTA_plot_effect_CONT}
\title{Function that visualizes the impact of the cutoff location on the treatment effect estimate.
It plots too figures. The bottom figure depicts the posterior density of the cutoff location.
The top figure depicts the box plot of the treatment effect given the cutoff point.
If the prior on the cutoff location was discrete each box corresponds to a distinct cutoff point.
If the prior was continuous each box correspond to an interval of cutoff values
(the number of intervals can be changed through nbins).}
\usage{
LoTTA_plot_effect_CONT(
  LoTTA_posterior,
  nbins = 10,
  probs = c(0.025, 0.975),
  x_lab = "Cutoff location",
  y_lab1 = "Treatment effect",
  y_lab2 = "Density of cutoff location",
  title = "Cutoff location vs. Treatment effect",
  axis.text = element_text(family = "sans", size = 10),
  text = element_text(family = "serif"),
  plot.theme = theme_classic(base_size = 14),
  plot.title = element_text(hjust = 0.5),
  ...
)
}
\arguments{
\item{LoTTA_posterior}{\itemize{
\item output of one of the LoTTA functions (LoTTA_fuzzy_CONT, LoTTA_fuzzy_BIN)
with all parameters sampled (the default option in those functions)
}}

\item{nbins}{\itemize{
\item number of bins to aggregate the input data
}}

\item{probs}{\itemize{
\item list of two quantiles that limit the range of cutoff values displayed on the plots
}}

\item{x_lab}{\itemize{
\item label of the x-axis
}}

\item{y_lab1}{\itemize{
\item label of the y-axis of the bottom plot
}}

\item{y_lab2}{\itemize{
\item label of the y-axis of the top plot
}}

\item{title}{\itemize{
\item title of the plot
}}

\item{axis.text}{\itemize{
\item can be any value that is accepted in the argument \emph{axis.text} in the \emph{theme} function
of ggplot2 package,refer to ggplot2 manual for the possible values;
by default is changes font to a serif one axis.text=element_text(family = "sans",size = 10)
}}

\item{text}{\itemize{
\item can be any value that is accepted in the argument \emph{text} in the \emph{theme} function
of ggplot2 package,refer to ggplot2 manual for the possible values;
by default is changes font to a serif one text=element_text(family='serif')
}}

\item{plot.theme}{\itemize{
\item ggplot2 plot theme (see https://ggplot2.tidyverse.org/reference/ggtheme.html)
possibly with additional arguments, it takes the default value plot.theme=theme_classic(base_size = 14),
}}

\item{plot.title}{\itemize{
\item can be any value that is accepted in the argument \emph{plot.title} in the \emph{theme} function
of ggplot2 package,refer to ggplot2 manual for the possible values;
by default it centers the plot title plot.title = element_text(hjust = 0.5)
}}

\item{...}{\itemize{
\item other arguments of the \emph{theme} function, refer to ggplot2 manual
}}
}
\value{
ggplot2 object
}
\description{
Function that visualizes the impact of the cutoff location on the treatment effect estimate.
It plots too figures. The bottom figure depicts the posterior density of the cutoff location.
The top figure depicts the box plot of the treatment effect given the cutoff point.
If the prior on the cutoff location was discrete each box corresponds to a distinct cutoff point.
If the prior was continuous each box correspond to an interval of cutoff values
(the number of intervals can be changed through nbins).
}
