% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DWLindley.R
\name{DWLindley}
\alias{DWLindley}
\alias{ddwlindley}
\alias{pdwlindley}
\alias{qdwlindley}
\alias{rdwlindley}
\title{Discrete Weighted Lindley Distribution}
\source{
[d-p-q-r]dwlindley are calculated directly from the definitions. \code{rdwlindley} uses the discretize values.
}
\usage{
ddwlindley(x, theta, alpha, log = FALSE)

pdwlindley(q, theta, alpha, lower.tail = TRUE, log.p = FALSE)

qdwlindley(p, theta, alpha, lower.tail = TRUE, log.p = FALSE)

rdwlindley(n, theta, alpha)
}
\arguments{
\item{x, q}{vector of integer positive quantiles.}

\item{theta, alpha}{positive parameter.}

\item{log, log.p}{logical; If TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; If TRUE, (default), \eqn{P(X \leq x)} are returned, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{ddwlindley} gives the probability mass function, \code{pdwlindley} gives the distribution function, \code{qdwlindley} gives the quantile function and \code{rdwlindley} generates random deviates.

Invalid arguments will return an error message.
}
\description{
Probability mass function, distribution function, quantile function and random number generation for the discrete weighted Lindley distribution with parameters theta and alpha.
}
\details{
Probability mass function
\deqn{P(X=x\mid \theta ,\alpha )=\frac{1}{\left( \theta +\alpha \right) \Gamma \left( \alpha \right) }\sum\limits_{i=0}^{1}\left( -1\right) ^{i}\left\{ \left( \theta +\alpha \right) \Gamma \left[ \alpha ,\theta \left( x+i\right) \right] +\left[\theta \left( x+i\right) \right] ^{\alpha }e^{-\theta \left( x+i\right)}\right\} }

where \eqn{\Gamma \left(\alpha,\theta x\right) = \int_{\theta x}^{\infty}x^{\alpha -1}e^{-x}dx} is the upper incomplete gamma function.

\bold{Particular case:} \eqn{\alpha = 1} the one-parameter discrete Lindley distribution.
}
\examples{
set.seed(1)
x <- rdwlindley(n = 1000, theta = 1.5, alpha = 1.5)
plot(table(x) / sum(table(x)))
points(unique(x),ddwlindley(unique(x), theta = 1.5, alpha = 1.5))

## fires in Greece data (from Bakouch et al., 2014)
data(fires)
library(fitdistrplus)
fit <- fitdist(fires, 'dwlindley', start = list(theta = 0.30, alpha = 1.0), discrete = TRUE)
gofstat(fit, discrete = TRUE)
plot(fit)

}
\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

Ricardo P. de Oliveira \email{rpuziol.oliveira@gmail.com}
}
\references{
Al-Mutairi, D. K., Ghitany, M. E., Kundu, D., (2015). Inferences on stress-strength reliability from weighted Lindley distributions. \emph{Communications in Statistics - Theory and Methods}, \bold{44}, (19), 4096-4113.

Bashir, S., Rasul, M., (2015). Some properties of the weighted Lindley distribution. \emph{EPRA Internation Journal of Economic and Business Review}, \bold{3}, (8), 11-17.

Ghitany, M. E., Alqallaf, F., Al-Mutairi, D. K. and Husain, H. A., (2011). A two-parameter weighted Lindley distribution and its applications to survival data. \emph{Mathematics and Computers in Simulation}, \bold{81}, (6), 1190-1201.

Mazucheli, J., Louzada, F., Ghitany, M. E., (2013). Comparison of estimation methods for the parameters of the weighted Lindley distribution. \emph{Applied Mathematics and Computation}, \bold{220}, 463-471.

Mazucheli, J., Coelho-Barros, E. A. and Achcar, J. (2016). An alternative reparametrization on the weighted Lindley distribution. \emph{Pesquisa Operacional}, (to appear).
}
\seealso{
\code{\link[LindleyR]{WLindley}}.
}

