% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateArcPointsDist.R
\name{CreateArcPointsDist}
\alias{CreateArcPointsDist}
\title{Creates an arc of a circumference to connect two points}
\usage{
CreateArcPointsDist(P1, P2, r)
}
\arguments{
\item{P1}{Vector containing the xy-coordinates of point 1}

\item{P2}{Vector containing the xy-coordinates of point 2}

\item{r}{Radius for the circumference which is used to generate the arc. This parameter is necessary because there are infinite possible arcs that connect two points. In the case the radius is smaller than half the distance between \code{P1} and \code{P2}, there is no possible arc, so the function tells the user}
}
\value{
Returns a vector which contains the center, radius and angles (0-360) that define the created arc
}
\description{
\code{CreateArcPointsDist} creates an arc of a circumference to connect two points
}
\examples{
x_min <- -5
x_max <- 5
y_min <- -5
y_max <- 5
CoordinatePlane(x_min, x_max, y_min, y_max)
P1 <- c(0,0)
P2 <- c(3,3)
r <- sqrt(18)/2
Arc <- CreateArcPointsDist(P1, P2, r)
Draw(Arc, "black")
}
