% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LavaCvxr.R
\name{LavaCvxr}
\alias{LavaCvxr}
\title{Lava Estimation for the Sum of Sparse and Dense Signals(3 Methods).}
\usage{
LavaCvxr(
  X,
  Y,
  K,
  Lambda1,
  Lambda2,
  method = c("Profile", "Iteration", "LavaCvxr"),
  Maxiter = 50
)
}
\arguments{
\item{X}{n by p data matrix, where n and p respectively denote the sample size and the number of regressors.}

\item{Y}{n by 1 matrix of outcome.}

\item{K}{the K fold cross validation.}

\item{Lambda1}{If you choose \code{'Profile'} or \code{'Iteration'}, \code{'Lambda1'} should be a vector of candidate values
to be evaluated in the cross validation to find an optimal \code{'Lambda1'}. If you choose \code{'LavaCvxr'}, \code{'Lambda1'}
can be a vector (go through the cross validation to get an optimal value) or an any specific value you choose (without going through
the cross validation part).}

\item{Lambda2}{If you choose \code{'Profile'} or \code{'Iteration'}, \code{'Lambda2'} should be a vector of candidate values
to be evaluated in the cross validation to find an optimal \code{'Lambda2'}. If you choose \code{'LavaCvxr'}, \code{'Lambda2'}
can be a vector (go through the cross validation to get an optimal value) or an any specific value you choose (without going through
the cross validation part).}

\item{method}{choose among \code{'Profile'}, \code{'Iteration'} and \code{'LavaCvxr'}. \code{'Profile'} computes using the profiled lasso method.
\code{'Iteration'} computes using iterating lasso and ridge. \code{'LavaCvxr'} computes using CVXR method to calculate. \code{'Profile'}
and \code{'Iteration'} depends on the 'Lavash' function in 'Lavash' package. For more details, please see the document for 'Lavash'.}

\item{Maxiter}{the maximum number of iterations. The default value is 50. Only used when 'Iteration' is selected.}
}
\value{
An \code{'output_list'} containing the following components:
\item{lava_dense}{parameter estimate of the dense component using lava.}
\item{lava_sparse}{parameter estimate of the sparse component using lava.}
\item{lava_estimate}{lava_estimate=lava_dense+lave_sparse: final parameter estimate using lava.}
\item{postlava_dense}{parameter estimate of the dense component using post-lava.}
\item{postlava_sparse}{parameter estimate of the sparse component using post-lava.}
\item{postlava_estimaate}{postlava_estimate=postlava_dense+postlava_sparse: final parameter estimate using post-lava.}
\item{LAMBDA}{[lambda1lava,lambda2lava, lambda1post, lambda2post]: These are the CV-chosen for optimal \code{'Lambda1'} and \code{'Lambda2'}
for lava and post-lava or the specific value that you choose without going through the cross validation part.}
}
\description{
The lava estimation is used to recover signals that is the sum of a sparse signal and a dense signal.
The post-lava method corrects the shrinkage bias of lava.
The model is Y=X*B+error,
 where B can be decomposed into B(theta)=dense part(beta)+sparse part(delta).
 Lava solves the following problem: min_[beta,delta] 1/n*|Y-X*(beta+delta)|_2^2+lamda2*|beta|_2^2+lambda1*|delta|_1.
 The final estimator is theta, which is theta=beta+delta. Both tuning parameters lambda1 and lambda2 are chosen using the K-fold cross-validation.
}
\details{
If you choose \code{'Profile'} method or \code{'Iteration'} method, we recommend using a relatively long vector of Lambda1
(e.g., 50 or 100 values),
but a short vector of Lambda2 (e.g., within 10).
Higher dimensions of Lambda2 substantially increase the computational time because a 'for' loop is called for Lambda2.
\code{'Profile'} and \code{'Iteration'} depends on the 'Lavash' function in 'Lavash' package. For more details, please see the document for 'Lavash'.
}
\examples{
N <- 20
P <- 10
K<-5

X <- matrix(rnorm(n = N * P, mean = 0, sd = 3), nrow = N, ncol = P)
beta_true <- as.matrix(rep(x = 0, times = P) )
delta_true <- as.matrix(rep(x = 0, times = P))
beta_true[1:P]<-0.1
delta_true[1:4] <- c(2, -2, 3, 6)
Y <- X\%*\%delta_true+X\%*\%beta_true + rnorm(N, mean = 0, sd = 2)

lambda1<-seq(0.01,2,by=6/20)
lambda2<-c(0.01,0.07,0.2,0.7,3,10,60,1000,6000)

lava_result<-LavaCvxr(X,Y,K,lambda1,lambda2,method=c('Profile'), Maxiter=50)

lava_result$lava_dense
lava_result$lava_sparse
lava_result$lava_estimate
lava_result$postlava_dense
lava_result$postlava_sparse
lava_result$postlava_estimate
lava_result$LAMBDA

}
\references{
Chernozhukov, V., Hansen, C., and Liao, Y. (2017) "A lava attack on the recovery of sums of dense and sparse signals", Annals of Statistics, 45, 39-76
}
\author{
Victor Chernozhukov, Christian Hansen, Yuan Liao, Jaeheon Jung, Yang Liu
}
\keyword{lava}
