% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploratory.R
\name{an_parallel}
\alias{an_parallel}
\title{Parallel Analysis}
\usage{
an_parallel(x = NA, iterations = 0, centile = 0, 
 seed = 0,mat = NA, n = NA)
}
\arguments{
\item{x}{a matrix or a dataframe that holds the test response data.}

\item{iterations}{how many iterations are performed during the analysis. Amount of random datasets produced.}

\item{centile}{a number between 1 and 99 indicating the centile used in estimating bias.}

\item{seed}{seed used for the random data generation.}

\item{mat}{a supplied correlation mtrix to use instead of x. If used, then n must be also supplied.}

\item{n}{the number of observations. Required when a correlation matrix is supplied 
with the mat option.}
}
\value{
Retained Components a scalar integer representing the number of retained components.

Adjusted Eigenvalues a vector of the estimated adjusted eigenvalues.

Unadjusted Eigenvalues a vector of the eigenvalues of the observed data from
an unrotated principal component analysis.

Bias a vector of the estimated bias of the unadjusted eigenvalues
}
\description{
Performs Horn's parallel analysis for a principal component.
}
\details{
Implementation of Horn's (1965) tecnique for evaluating the components retained
in a principle component analysis (PCA). This procedure is an adaptation of the
paran function in the Paran Package.
}
\examples{
\dontrun{
 data <- simulate_dichotomous(size.cluster = c(10),sample.size=1000)
 an_parallel(data$data, iterations = 100, centile = 99, seed = 12)
}
}
\references{
John L. Horn (1965). A rationale and test for the number of factors 
in factor analysis. Psychometrika, Volume 30, Number 2, Page 179.

Dinno A. 2009. Exploring the Sensitivity of Horn's Parallel Analysis to the 
Distributional Form of Simulated Data. Multivariate Behavioral Research. 44(3): 362-388
}

