% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulate_under_LTM.R
\name{simulate_under_LTM_multi}
\alias{simulate_under_LTM_multi}
\title{Simulate under the liability threshold model (multiple phenotypes).}
\usage{
simulate_under_LTM_multi(
  fam_vec = c("m", "f", "s1", "mgm", "mgf", "pgm", "pgf"),
  n_fam = NULL,
  add_ind = TRUE,
  genetic_corrmat = diag(3),
  full_corrmat = diag(3),
  h2_vec = rep(0.5, 3),
  phen_names = NULL,
  n_sim = 1000,
  pop_prev = rep(0.1, 3)
)
}
\arguments{
\item{fam_vec}{A vector of strings holding the different
family members. All family members must be represented by strings from the
following list:
- \code{m} (Mother)
- \code{f} (Father)
- \code{c[0-9]*.[0-9]*} (Children)
- \code{mgm} (Maternal grandmother)
- \code{mgf} (Maternal grandfather)
- \code{pgm} (Paternal grandmother)
- \code{pgf} (Paternal grandfather)
- \code{s[0-9]*} (Full siblings)
- \code{mhs[0-9]*} (Half-siblings - maternal side)
- \code{phs[0-9]*} (Half-siblings - paternal side)
- \code{mau[0-9]*} (Aunts/Uncles - maternal side)
- \code{pau[0-9]*} (Aunts/Uncles - paternal side).
 Defaults to \code{c("m","f","s1","mgm","mgf","pgm","pgf")}.}

\item{n_fam}{A named vector holding the desired number of family members.
See  \code{\link[stats]{setNames}}.
All names must be picked from the list mentioned above. Defaults to \code{NULL}.}

\item{add_ind}{A logical scalar indicating whether the genetic
component of the full liability as well as the full
liability for the underlying target individual should be included in
the covariance matrix. Defaults to \code{TRUE}.}

\item{genetic_corrmat}{A numeric matrix holding the genetic correlations
between the desired phenotypes. All diagonal entries must be equal to one,
while all off-diagonal entries must be between -1 and 1. In addition,
the matrix must be symmetric.
Defaults to \code{diag(3)}.}

\item{full_corrmat}{A numeric matrix holding the full correlations
between the desired phenotypes. All diagonal entries must be equal to
one, while all off-diagonal entries must be between -1 and 1. In addition,
the matrix must be symmetric.
Defaults to \code{diag(3)}.}

\item{h2_vec}{A numeric vector holding the liability-scale heritabilities
for a number of phenotype. All entries must be non-negative. Note that under
the liability threshold model, the heritabilities must also be at most 1.
Defaults to \code{rep(0.5,3)}.}

\item{phen_names}{A character vector holding the phenotype names. These names
will be used to create the row and column names for the covariance matrix.
If it is not specified, the names will default to phenotype1, phenotype2, etc.
Defaults to \code{NULL}.}

\item{n_sim}{A positive number representing the number of simulations. Defaults to 1000.}

\item{pop_prev}{A numeric vector holding the population prevalences, i.e. the
overall prevalences in the population. All entries in \code{pop_prev} must be positive
and smaller than 1. Defaults to \code{rep(.1,3)}.}
}
\value{
If either \code{fam_vec} or \code{n_fam} is used as the argument and if it is of the
required format, if \code{genetic_corrmat} and \code{full_corrmat} are two numeric
and symmetric matrices satisfying that all diagonal entries are one and that all
off-diagonal entries are between -1 and 1, if the liability-scale heritabilities in
\code{h2_vec} are numbers satisfying \eqn{0 \leq h^2_i} for all \eqn{i \in \{1,...,n_pheno\}},
\code{n_sim} is a strictly positive number, and \code{pop_prev} is a positive numeric
vector such that all entries are at most one,
then the output will be a list containing lists for each phenotype.
The first outer list, which is named after the first phenotype in \code{phen_names},
holds the tibble \code{sim_obs}, which holds the simulated liabilities, the
disease status and the current age/age-of-onset for all family members in each of
the \code{n_sim} families for the first phenotype.
As the first outer list, the second outer list, which is named after the second
phenotype in \code{phen_names}, holds the tibble \code{sim_obs}, which holds
the  simulated liabilities, the disease status and the current age/age-of-onset
for all family members in each of the \code{n_sim} families for the second phenotype.
There is a list containing \code{sim_obs} for each phenotype in \code{phen_names}.
The last list entry, \code{thresholds}, holds the family identifier, the personal
identifier, the role (specified in fam_vec or n_fam) as well as the lower and
upper thresholds for all individuals in all families and all phenotypes.
Note that this tibble has the format required in \code{\link{estimate_liability}}.
Finally, note that if neither \code{fam_vec} nor \code{n_fam} are specified, the function
returns the disease status, the current age/age-of-onset, the lower and upper
thresholds, as well as the personal identifier for a single individual, namely
the individual under consideration (called \code{o}).
If both \code{fam_vec} and \code{n_fam} are defined, the user is asked to '
decide on which of the two vectors to use.
}
\description{
\code{simulate_under_LTM_multi} simulates families and thresholds under
the liability threshold model for a given family structure and multiple
phenotypes. Please note that it is not possible to simulate different
family structures.
}
\examples{
simulate_under_LTM_multi()

genetic_corrmat <- matrix(0.4, 3, 3)
diag(genetic_corrmat) <- 1
full_corrmat <- matrix(0.6, 3, 3)
diag(full_corrmat) <- 1

simulate_under_LTM_multi(fam_vec = NULL, n_fam = stats::setNames(c(1,1,1,2,2),
c("m","mgm","mgf","s","mhs")))

simulate_under_LTM_multi(fam_vec = c("m","f","s1"), add_ind = FALSE,
genetic_corrmat = genetic_corrmat, full_corrmat = full_corrmat, n_sim = 100)

simulate_under_LTM_multi(fam_vec = c(), n_fam = NULL, add_ind = TRUE, n_sim = 150)

}
\seealso{
\code{\link{construct_covmat}}
}
