% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textplot.R
\name{textplot_terms}
\alias{textplot_terms}
\title{Plot polarity scores of words}
\usage{
textplot_terms(
  x,
  highlighted = NULL,
  max_highlighted = 50,
  max_words = 1000,
  sampling = c("absolute", "relative"),
  ...
)
}
\arguments{
\item{x}{a fitted textmodel_lss object.}

\item{highlighted}{\link[quanteda:pattern]{quanteda::pattern} to select words to highlight. If a
\link[quanteda:dictionary]{quanteda::dictionary} is passed, words in the top-level categories are
highlighted in different colors.}

\item{max_highlighted}{the maximum number of words to highlight. When
\code{highlighted = NULL}, words are randomly sampled proportionally to
\code{beta ^ 2 * log(frequency)} for highlighting.}

\item{max_words}{the maximum number of words to plot. Words are randomly
sampled to keep the number below the limit.}

\item{sampling}{if "relative", words are sampled based on their squared deviation
from the mean for highlighting; if "absolute", they are sampled
based on the squared distance from zero.}

\item{...}{passed to underlying functions. See the Details.}
}
\description{
Plot polarity scores of words
}
\details{
Users can customize the plots through \code{...}, which is
passed to \code{\link[ggplot2:geom_text]{ggplot2::geom_text()}} and \code{\link[ggrepel:geom_text_repel]{ggrepel::geom_text_repel()}}. The
colors are specified internally but users can override the settings by appending
\code{\link[ggplot2:scale_manual]{ggplot2::scale_colour_manual()}} or \code{\link[ggplot2:scale_brewer]{ggplot2::scale_colour_brewer()}}. The
legend title can also be modified using \code{\link[ggplot2:labs]{ggplot2::labs()}}.
}
