% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LST.R
\name{E_Skokovic}
\alias{E_Skokovic}
\title{Land Surface Emissivity according to Skokovic et al. 2014}
\usage{
E_Skokovic(red = red, NDVI = NDVI, band = band)
}
\arguments{
\item{red}{Raster* object, red band of remote sensing imagery}

\item{NDVI}{Raster* object, NDVI calculated from remote sensing imagery}

\item{band}{A string specifying which Landsat 8 thermal band to use. It can be "band 10" or
"band 11"}
}
\value{
RasterLayer
}
\description{
This function calculates Land Surface Emissivity according to Skokovic et al. 2014
}
\examples{
red <- raster::raster(ncol=100, nrow=100)
set.seed(2)
raster::values(red) = runif(10000, min=0.1, max=0.4)
NDVI <- raster::raster(ncol=100, nrow=100)
set.seed(2)
raster::values(NDVI) = runif(10000, min=0.02, max=0.8)
E_Skokovic(red = red, NDVI = NDVI, band = "band 11")
}
