SVDmat<-function(E,maxTriess=3000,intervall=30)
{
  write.table(E,file="E.txt",col.names=F,row.names=F)
  linkE<-noquote(paste(getwd(),"E.txt",sep="/"))
  link<-noquote(getwd())
  R.matlab::Matlab$startServer()
  matlab <- R.matlab::Matlab(port=9999)
  R.matlab::setOption(matlab, "readResult/maxTries", maxTriess)
  R.matlab::setOption(matlab, "readResult/interval", intervall)
  open(matlab)
  R.matlab::setVariable(matlab,linkE = linkE)
  R.matlab::setVariable(matlab,link = link)
  R.matlab::evaluate(matlab, "E = dlmread(linkE);")
  R.matlab::evaluate(matlab, "[U,S,V] = svd(E,'econ');")
  R.matlab::evaluate(matlab, "S = diag(S);")
  R.matlab::evaluate(matlab, "folder = link;")
  R.matlab::evaluate(matlab, "dlmwrite('U.txt',U,'delimiter',' ');")
  R.matlab::evaluate(matlab, "dlmwrite('D.txt',S,'delimiter',' ');")
  R.matlab::evaluate(matlab, "dlmwrite('V.txt',V,'delimiter',' ');")
  close(matlab)
  d<-read.table("D.txt");d<-as.matrix(d);colnames(d)<-c();d<-d[,1]
  u<-read.table("U.txt");u<-as.matrix(u);colnames(u)<-c()
  v<-read.table("V.txt");v<-as.matrix(v);colnames(v)<-c()
  SVD<-list(d=d,u=u,v=v)
  file.remove("E.txt","U.txt","D.txt","V.txt")
  return(SVD)
}
