% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDM_fun.R
\name{avgdist.squared}
\alias{avgdist.squared}
\title{Averaging the squared distance matrices each calculated from a rarefied OTU table}
\usage{
avgdist.squared(
  otu.table,
  dist.method = "jaccard",
  tree = NULL,
  scale.otu.table = FALSE,
  n.rarefy = 100,
  binary = TRUE,
  seed = 123
)
}
\arguments{
\item{otu.table}{the \code{n.obs} by \code{n.otu} matrix of read counts.}

\item{dist.method}{method for calculating the distance measure, partial
match to all methods supported by \code{vegdist} in the \code{vegan} package. The default is "jaccard". 
For more details, see the \code{dist.method} argument in the \code{ldm} function.}

\item{tree}{the phylogeneic tree. The default is NULL.}

\item{scale.otu.table}{a logical variable indicating whether to scale the rows of the OTU table. 
For count data, this corresponds to dividing by the library size to give relative frequencies. 
The default is FALSE.}

\item{n.rarefy}{number of rarefactions. The default is 100.}

\item{binary}{the "binary" parameter in \code{vegdist}. The default is TRUE.}

\item{seed}{a single-value integer seed for the random process of drawing rarefaction replicates. 
The seed is user supplied or internally generated. The default is 123.}
}
\value{
a single matrix object
  \item{D2.avg}{The average of the squared distance matrices.}
}
\description{
This function computes a distance matrix for each rarefied OTU table, square the distance matrix (in an element-wise manner), 
and then average the squared distance matrices.
}
\examples{
dist.avg.D2 <- avgdist.squared(throat.otu.tab5, dist.method="jaccard", n.rarefy=100)
}
\author{
Yi-Juan Hu <yijuan.hu@emory.edu>, Glen A. Satten <gsatten@emory.edu>
}
\keyword{microbiome}
