% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA_plot_activity.R
\name{LDA_plot_activity}
\alias{LDA_plot_activity}
\title{LDA_plot_activity}
\usage{
LDA_plot_activity(LDA_obj, xlim = NULL, uncertainty.band = FALSE)
}
\arguments{
\item{LDA_obj}{list returned from LDA_prepare_plot}

\item{xlim}{manually setting the xlim}

\item{uncertainty.band}{plotting uncertainty bands TRUE/FALSE}
}
\value{
none
}
\description{
generate clonogenic activity estimation plot (frequency of
  negative wells over the number of cells seeded) for data of limiting
  dilution assay (LDA) experiments. Input is an data object as returned by
  the preprocessing function LDA_prepare_plot().
}
\examples{
x <- data.frame("cells" = rep(c(10,50,100,250),times = 4),
                "wells" = rep(25,16),
                "positive" = c(2,5,10,20,1,2,6,11,3,4,8,22,1,1,7,12),
                "group" = rep(c(rep("A",4),rep("B",4)),times = 2),
                "replicate" = c(rep(1,8),rep(2,8)))
out <- LDA_prepare_plot(x)
LDA_plot_activity(out[[1]])
data(LDAdata)
Z1 <- subset.data.frame(LDAdata,subset = name == unique(LDAdata$name)[1])
out <- LDA_prepare_plot(Z1[,c("S-value","# Tested","# Clonal growth",
                              "Group","replicate")])
LDA_plot_activity(out[[1]])
}
