/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.morph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.kr.morph.CompoundEntry;
import org.apache.lucene.analysis.kr.morph.MorphException;
import org.apache.lucene.analysis.kr.morph.WordEntry;
import org.apache.lucene.analysis.kr.utils.DictionaryUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundNounAnalyzer {
    private static int score = 1;
    private boolean exactMach = true;
    private static Pattern NUM_PATTERN = Pattern.compile("^[0-9\\.,]+$");
    private static Pattern ALPHANUM_PATTERN = Pattern.compile("^[0-9A-Za-z\\.,]+$");

    public boolean isExactMach() {
        return this.exactMach;
    }

    public void setExactMach(boolean exactMach) {
        this.exactMach = exactMach;
    }

    public List analyze(String input) throws MorphException {
        return this.analyze(input, true);
    }

    public List analyze(String input, boolean isFirst) throws MorphException {
        int len = input.length();
        if (len < 3) {
            return new ArrayList();
        }
        ArrayList outputs = new ArrayList();
        switch (len) {
            case 3: {
                this.analyze3Word(input, outputs, isFirst);
                break;
            }
            case 4: {
                this.analyze4Word(input, outputs, isFirst);
                break;
            }
            case 5: {
                this.analyze5Word(input, outputs, isFirst);
                break;
            }
            case 6: {
                this.analyze6Word(input, outputs, isFirst);
                break;
            }
            default: {
                this.analyzeLongText(input, outputs, isFirst);
            }
        }
        return outputs;
    }

    private void analyze3Word(String input, List outputs, boolean isFirst) throws MorphException {
        int[] units1 = new int[]{2, 1};
        CompoundEntry[] entries1 = this.analysisBySplited(units1, input, isFirst);
        if (entries1 != null && entries1[0].isExist() && entries1[1].isExist()) {
            outputs.addAll(Arrays.asList(entries1));
            return;
        }
        int[] units2 = new int[]{1, 2};
        CompoundEntry[] entries2 = this.analysisBySplited(units2, input, isFirst);
        if (entries2 != null && entries2[0].isExist() && entries2[1].isExist()) {
            outputs.addAll(Arrays.asList(entries2));
        }
    }

    private void analyze4Word(String input, List outputs, boolean isFirst) throws MorphException {
        int[] units0;
        CompoundEntry[] entries0;
        if (!isFirst && (entries0 = this.analysisBySplited(units0 = new int[]{1, 3}, input, isFirst)) != null && entries0[0].isExist() && entries0[1].isExist()) {
            outputs.addAll(Arrays.asList(entries0));
            return;
        }
        int[] units2 = new int[]{1, 2, 1};
        CompoundEntry[] entries2 = this.analysisBySplited(units2, input, isFirst);
        if (entries2 != null && entries2[0].isExist() && entries2[1].isExist() && entries2[2].isExist()) {
            outputs.addAll(Arrays.asList(entries2));
            return;
        }
        int[] units1 = new int[]{2, 2};
        CompoundEntry[] entries1 = this.analysisBySplited(units1, input, isFirst);
        if (entries1 != null && entries1[0].isExist() && entries1[1].isExist()) {
            outputs.addAll(Arrays.asList(entries1));
            return;
        }
        if (!this.exactMach && entries1 != null && (entries1[0].isExist() || entries1[1].isExist())) {
            outputs.addAll(Arrays.asList(entries1));
        }
    }

    private void analyze5Word(String input, List outputs, boolean isFirst) throws MorphException {
        int[] units1 = new int[]{2, 3};
        CompoundEntry[] entries1 = this.analysisBySplited(units1, input, isFirst);
        if (entries1 != null && entries1[0].isExist() && entries1[1].isExist()) {
            outputs.addAll(Arrays.asList(entries1));
            return;
        }
        int[] units2 = new int[]{3, 2};
        CompoundEntry[] entries2 = this.analysisBySplited(units2, input, isFirst);
        if (entries2 != null && entries2[0].isExist() && entries2[1].isExist()) {
            outputs.addAll(Arrays.asList(entries2));
            return;
        }
        int[] units_1 = new int[]{4, 1};
        CompoundEntry[] entries_1 = this.analysisBySplited(units_1, input, isFirst);
        if (entries_1 != null && entries_1[0].isExist() && entries_1[1].isExist()) {
            outputs.addAll(Arrays.asList(entries_1));
            return;
        }
        int[] units3 = new int[]{2, 2, 1};
        CompoundEntry[] entries3 = this.analysisBySplited(units3, input, isFirst);
        if (entries3 != null && entries3[0].isExist() && entries3[1].isExist() && entries3[2].isExist()) {
            outputs.addAll(Arrays.asList(entries3));
            return;
        }
        int[] units4 = new int[]{2, 1, 2};
        CompoundEntry[] entries4 = this.analysisBySplited(units4, input, isFirst);
        if (entries4 != null && entries4[0].isExist() && entries4[1].isExist() && entries4[2].isExist()) {
            outputs.addAll(Arrays.asList(entries4));
            return;
        }
        if (!this.exactMach && entries1 != null && (entries1[0].isExist() || entries1[1].isExist())) {
            outputs.addAll(Arrays.asList(entries1));
            return;
        }
        if (!this.exactMach && entries2 != null && (entries2[0].isExist() || entries2[1].isExist())) {
            outputs.addAll(Arrays.asList(entries2));
            return;
        }
        if (!this.exactMach && entries3 != null && (entries3[0].isExist() || entries3[1].isExist())) {
            outputs.addAll(Arrays.asList(entries3));
        }
        if (!this.exactMach && entries4 != null && (entries4[0].isExist() || entries4[2].isExist())) {
            outputs.addAll(Arrays.asList(entries4));
        }
    }

    private void analyze6Word(String input, List outputs, boolean isFirst) throws MorphException {
        int[] units3 = new int[]{2, 4};
        CompoundEntry[] entries3 = this.analysisBySplited(units3, input, isFirst);
        if (entries3 != null && entries3[0].isExist() && entries3[1].isExist()) {
            outputs.addAll(Arrays.asList(entries3));
            return;
        }
        int[] units4 = new int[]{4, 2};
        CompoundEntry[] entries4 = this.analysisBySplited(units4, input, isFirst);
        if (entries4 != null && entries4[0].isExist() && entries4[1].isExist()) {
            outputs.addAll(Arrays.asList(entries4));
            return;
        }
        int[] units2 = new int[]{3, 3};
        CompoundEntry[] entries2 = this.analysisBySplited(units2, input, isFirst);
        if (entries2 != null && entries2[0].isExist() && entries2[1].isExist()) {
            outputs.addAll(Arrays.asList(entries2));
            return;
        }
        int[] units6 = new int[]{3, 2, 1};
        CompoundEntry[] entries6 = this.analysisBySplited(units6, input, isFirst);
        if (entries6 != null && entries6[0].isExist() && entries6[1].isExist()) {
            outputs.addAll(Arrays.asList(entries6));
            return;
        }
        int[] units7 = new int[]{2, 3, 1};
        CompoundEntry[] entries7 = this.analysisBySplited(units7, input, isFirst);
        if (entries7 != null && entries7[0].isExist() && entries7[1].isExist()) {
            outputs.addAll(Arrays.asList(entries7));
            return;
        }
        int[] units1 = new int[]{2, 2, 2};
        CompoundEntry[] entries1 = this.analysisBySplited(units1, input, isFirst);
        if (entries1 != null && entries1[0].isExist() && entries1[1].isExist() && entries1[2].isExist()) {
            outputs.addAll(Arrays.asList(entries1));
            return;
        }
        int[] units5 = new int[]{2, 1, 2, 1};
        CompoundEntry[] entries5 = this.analysisBySplited(units5, input, isFirst);
        if (entries5 != null && entries5[0].isExist() && entries5[1].isExist() && entries5[2].isExist() && entries5[3].isExist()) {
            outputs.addAll(Arrays.asList(entries5));
            return;
        }
        if (!this.exactMach && entries1 != null && this.canCompound(entries1, 2 * score)) {
            outputs.addAll(Arrays.asList(entries1));
            return;
        }
        if (!this.exactMach && entries2 != null && (entries2[0].isExist() || entries2[1].isExist())) {
            outputs.addAll(Arrays.asList(entries2));
            return;
        }
        if (!this.exactMach && entries3 != null && (entries3[0].isExist() || entries3[1].isExist())) {
            outputs.addAll(Arrays.asList(entries3));
            return;
        }
        if (!this.exactMach && entries4 != null && (entries4[0].isExist() || entries4[1].isExist())) {
            outputs.addAll(Arrays.asList(entries4));
        }
    }

    private void analyzeLongText(String input, List outputs, boolean isFirst) throws MorphException {
        int pos = input.length() / 2;
        if (input.length() % 2 == 1) {
            ++pos;
        }
        if (input.length() > 20) {
            return;
        }
        int score = 0;
        ArrayList<Object> results = new ArrayList();
        boolean hasContain = false;
        int i = pos;
        while (i >= 2) {
            String prev = input.substring(0, i);
            String rear = input.substring(i);
            ArrayList<CompoundEntry> candidates = new ArrayList<CompoundEntry>();
            CompoundEntry prevEntry = this.analyzeSingle(prev);
            if (prevEntry.isExist()) {
                candidates.add(prevEntry);
            } else {
                List list = this.analyze(prev, true);
                if (list.size() == 0) {
                    candidates.add(prevEntry);
                } else {
                    candidates.addAll(list);
                }
            }
            CompoundEntry e = (CompoundEntry)candidates.get(candidates.size() - 1);
            if (!hasContain && this.containWord(e.getWord(), input, i)) {
                i -= e.getWord().length() - 1;
                hasContain = true;
            } else {
                CompoundEntry rearEntry = this.analyzeSingle(rear);
                if (rearEntry.isExist() || rear.length() == 3) {
                    candidates.add(rearEntry);
                } else {
                    List list = this.analyze(rear, false);
                    if (list.size() == 0) {
                        if (!e.isExist()) {
                            candidates.set(candidates.size() - 1, this.analyzeSingle(String.valueOf(e.getWord()) + rearEntry.getWord()));
                        } else {
                            candidates.add(rearEntry);
                        }
                    } else {
                        if (!e.isExist()) {
                            candidates.set(candidates.size() - 1, this.analyzeSingle(String.valueOf(e.getWord()) + ((CompoundEntry)list.remove(0)).getWord()));
                        }
                        candidates.addAll(list);
                    }
                }
                int eval = this.evaluation(candidates);
                if (results == null || score < eval || score == eval && results.size() > candidates.size()) {
                    results = candidates;
                    score = eval;
                }
                if (eval == 110) break;
            }
            --i;
        }
        outputs.addAll(results);
    }

    private int evaluation(List<CompoundEntry> candidates) {
        int eval = 10;
        int one = 0;
        int exist = 0;
        for (CompoundEntry entry : candidates) {
            if (entry.getWord().length() == 1) {
                ++one;
            }
            if (!entry.isExist()) continue;
            ++exist;
        }
        if (one > 3) {
            return eval;
        }
        eval = eval + exist * 100 / candidates.size() - one * 100 / candidates.size();
        return eval;
    }

    private boolean containWord(String before, String input, int pos) throws MorphException {
        String prev = null;
        int i = pos;
        while (i < input.length()) {
            String text = String.valueOf(before) + input.substring(pos, i + 1);
            if (!DictionaryUtil.findWithPrefix(text).hasNext()) {
                if (prev == null || DictionaryUtil.getNoun(prev) == null) break;
                return true;
            }
            prev = text;
            ++i;
        }
        return false;
    }

    private CompoundEntry[] analysisBySplited(int[] units, String input, boolean isFirst) throws MorphException {
        CompoundEntry[] entries = new CompoundEntry[units.length];
        int pos = 0;
        String prev = null;
        int i = 0;
        while (i < units.length) {
            String str = input.substring(pos, pos + units[i]);
            if (i != 0 && !this.validCompound(prev, str, isFirst && i == 1, i)) {
                return null;
            }
            entries[i] = this.analyzeSingle(str);
            pos += units[i];
            prev = str;
            ++i;
        }
        return entries;
    }

    private boolean canCompound(CompoundEntry[] entries, int thredhold) {
        int achived = 0;
        int i = 0;
        while (i < entries.length) {
            if (entries[i].isExist()) {
                achived += score;
            }
            ++i;
        }
        return achived >= thredhold;
    }

    private CompoundEntry analyzeSingle(String input) throws MorphException {
        boolean success = false;
        int score = 30;
        int ptn = 1;
        int pos = 78;
        if (input.length() == 1) {
            return new CompoundEntry(input, 0, true, (char)pos);
        }
        WordEntry entry = DictionaryUtil.getWordExceptVerb(input);
        if (entry != null) {
            score = 100;
            if (entry.getFeature(0) != '1') {
                ptn = 21;
                pos = 90;
            }
        }
        return new CompoundEntry(input, 0, score == 100, (char)pos);
    }

    private boolean validCompound(String before, String after, boolean isFirst, int pos) throws MorphException {
        WordEntry entry2;
        List<CompoundEntry> compounds;
        WordEntry entry1;
        if (!(pos != 1 || before.length() != 1 || isFirst && DictionaryUtil.existPrefix(before))) {
            return false;
        }
        if (after.length() == 1 && !DictionaryUtil.existSuffix(after)) {
            return false;
        }
        if (pos != 1 && before.length() == 1 && (entry1 = DictionaryUtil.getUncompound(String.valueOf(before) + after)) != null && before.equals((compounds = entry1.getCompounds()).get(0).getWord()) && after.equals(compounds.get(1).getWord())) {
            return false;
        }
        WordEntry wordEntry = entry2 = after.length() == 1 ? null : DictionaryUtil.getUncompound(after);
        return entry2 == null || !"*".equals((compounds = entry2.getCompounds()).get(0).getWord()) || !after.equals(compounds.get(1).getWord());
    }
}

