/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.kr.utils.MorphUtil;

public class ConstraintUtil {
    private static Map hahes = new HashMap();
    private static Map eomiPnouns;
    private static Map PTN_MLIST;
    private static Map PTN_JLIST;
    private static Map WORD_GUKS;

    static {
        hahes.put("\ubbfc\uc871", "Y");
        hahes.put("\ub3d9\uc11c", "Y");
        hahes.put("\ub0a8\ubd81", "Y");
        eomiPnouns = new HashMap();
        eomiPnouns.put("\u3134", "Y");
        eomiPnouns.put("\u3139", "Y");
        eomiPnouns.put("\u3141", "Y");
        PTN_MLIST = new HashMap();
        PTN_MLIST.put(3, 3);
        PTN_MLIST.put(5, 5);
        PTN_MLIST.put(6, 6);
        PTN_MLIST.put(11, 11);
        PTN_MLIST.put(13, 13);
        PTN_MLIST.put(14, 14);
        PTN_MLIST.put(31, 31);
        PTN_JLIST = new HashMap();
        PTN_JLIST.put(2, 2);
        PTN_JLIST.put(4, 4);
        PTN_JLIST.put(12, 12);
        PTN_JLIST.put(15, 15);
        WORD_GUKS = new HashMap();
        WORD_GUKS.put("\ub0a0\uac83", "Y");
        WORD_GUKS.put("\ub4e4\uac83", "Y");
        WORD_GUKS.put("\ubcc4\uac83", "Y");
        WORD_GUKS.put("\ucc30\uac83", "Y");
        WORD_GUKS.put("\ud0c8\uac83", "Y");
        WORD_GUKS.put("\ud558\uc798\uac83", "Y");
    }

    public static boolean canHaheCompound(String key) {
        return hahes.get(key) != null;
    }

    public static boolean isNLM(String eomi) {
        if (eomi == null || "".equals(eomi)) {
            return false;
        }
        if (eomiPnouns.get(eomi) != null) {
            return true;
        }
        char[] chrs = MorphUtil.decompose(eomi.charAt(eomi.length() - 1));
        if (chrs.length == 3 && eomiPnouns.get(Character.toString(chrs[2])) != null) {
            return true;
        }
        return true;
    }

    public static boolean isEomiPhrase(int ptn) {
        return PTN_MLIST.get(ptn) != null;
    }

    public static boolean isJosaNounPhrase(int ptn) {
        return PTN_JLIST.get(ptn) != null;
    }

    public static boolean isJosaAdvPhrase(int ptn) {
        return 22 == ptn;
    }

    public static boolean isAdvPhrase(int ptn) {
        return 22 == ptn || 21 == ptn;
    }
}

