% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KnockoffHybrid.R
\name{KnockoffHybrid}
\alias{KnockoffHybrid}
\title{Calculate KnockoffHybrid's feature statistics}
\usage{
KnockoffHybrid(
  dat,
  dat.ko = NA,
  pos,
  allele = NA,
  start = NA,
  end = NA,
  size = c(1, 1000, 5000, 10000, 20000, 50000),
  p_value_only = FALSE,
  adjust_for_cov = FALSE,
  y = NA,
  chr = "1",
  sex = NA,
  weight = NULL
)
}
\arguments{
\item{dat}{A 3n*p matrix for the original trio genotype data, in which n is the number of trios and p is the number of variants. Each trio must consist of father, mother, and offspring (in this order). The genotypes must be coded as 0, 1, or 2. Missing genotypes are not allowed.}

\item{dat.ko}{A 3n*p*M array for the knockoff trio genotype data created by function create_knockoff. M is the number of knockoffs.}

\item{pos}{A numeric vector of length p for the position of p variants.}

\item{allele}{A vector of length p for the minor allele at each position. Minor alleles for windows with multiple variants will be shown as "W" in the output.}

\item{start}{An integer for the first position of sliding windows. If NA, start=min(pos). Only used if you would like to use the same starting position for different cohorts/analyses.}

\item{end}{An integer for the last position of sliding windows. If NA, end=max(pos). Only used if you would like to use the same ending position for different cohorts/analyses.}

\item{size}{A numeric vector for the size(s) of sliding windows when scanning the genome}

\item{p_value_only}{A logical value indicating whether to perform the knockoff analysis. When p_value_only is TRUE, only the ACAT-combined p-values are to be calculated for each window. When p_value_only is FALSE, dat.ko is required and KnockoffHybrid's feature statistics are to be calculated for each window in addition to the p-values.}

\item{adjust_for_cov}{A logical value indicating whether to adjust for covariates. When adjust_for_cov is TRUE, y is required.}

\item{y}{A numeric vector of length n for the residual Y-Y_hat. Y_hat is the predicted value from the regression model in which the quantitative trait Y is regressed on the covariates. If Y is dichotomous, you may treat Y as quantitative when applying the regression model.}

\item{chr}{A character for the name of the chromosome, e.g., "1", "2", ..., "22", and "X".}

\item{sex}{A numeric vector of length n for the sex of offspring. 0s indicate females and 1s indicate males.}

\item{weight}{A numeric vector of length p for the weight of p variants. The weight can be obtained via the function "calculate_weight" using population genotype or summary statistics. If NULL, the weight will be calculated based on minor allele frequencies.}
}
\value{
A data frame for the hybrid analysis results. Each row contains the p-values and, if p_value_only is FALSE, KnockoffHybrid's feature statistics for a window.
}
\description{
Calculate KnockoffHybrid's feature statistics using original and knockoff genotype data.
}
\examples{
data(KnockoffHybrid.example)
dat.ko<-create_knockoff(KnockoffHybrid.example$dat.hap,KnockoffHybrid.example$pos,M=10)
weight<-calculate_weight(geno=KnockoffHybrid.example$dat.pop,y=KnockoffHybrid.example$y.pop)
window<-KnockoffHybrid(dat=KnockoffHybrid.example$dat,dat.ko=dat.ko,
        pos=KnockoffHybrid.example$pos,weight=weight)
}
