% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comm_info_request.R
\name{comm_info_request}
\alias{comm_info_request}
\title{Inspect Handler}
\usage{
comm_info_request(request_msg)
}
\arguments{
\item{request_msg}{A list passed in from \code{doRequest} representing the
deserialized \code{comm_info_request} message JSON.}
}
\value{
A list having names \code{msg_type} and \code{content}. The
  \code{msg_type} is \code{comm_info_reply}, which corresponds
  to the \code{comm_info_request} message. The \code{content} field
  complies with the Jupyter wire message protocol specification
  for \code{comm_info_reply} messages.
}
\description{
Handler for the comm_info_request Message Type
}
\examples{
\dontrun{
  request_msg <- list("target"=NULL, "target_name"="my_open_comm_id")
  comm_info_request(request_msg)
}

}
\references{
\url{http://jupyter-client.readthedocs.io/en/latest/messaging.html#comm-info}
}
\author{
Spencer Aiello
}
