% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{call}
\alias{call}
\alias{julia_do.call}
\alias{julia_call}
\title{Call julia functions.}
\usage{
julia_do.call(func_name, arg_list, need_return = c("R", "Julia", "None"),
  show_value = FALSE)

julia_call(func_name, ..., need_return = c("R", "Julia", "None"),
  show_value = FALSE)
}
\arguments{
\item{func_name}{the name of julia function you want to call.}

\item{arg_list}{the list of the arguments you want to pass to the julia function.}

\item{need_return}{whether you want julia to return value as an R object,
a wrapper for julia object or no return.
The value of need_return could be TRUE (equal to option "R") or FALSE (equal to option "None"),
or one of the options "R", "Julia" and "None".}

\item{show_value}{whether to display julia return value or not.}

\item{...}{the arguments you want to pass to the julia function.}
}
\description{
\code{julia_do.call} is the \code{do.call} for julia.
And \code{julia_call} calls julia functions.
}
\examples{

\dontrun{ ## julia_setup is quite time consuming
  julia_do.call("sqrt", list(2))
  julia_call("sqrt", 2)
}

}
