% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_samples.R
\name{add_samples}
\alias{add_samples}
\title{Add samples to an object of class JointAI}
\usage{
add_samples(object, n.iter, add = TRUE, thin = NULL,
  monitor_params = NULL, progress.bar = "text")
}
\arguments{
\item{object}{object inheriting from class \code{JointAI}}

\item{n.iter}{number of iterations to monitor}

\item{add}{logical; should the new MCMC samples be added to the existing
samples or replace them? If samples are added, \code{thin} and
\code{var.names} are ignored}

\item{thin}{thinning interval for monitors}

\item{monitor_params}{named vector specifying which parameters should be
monitored, see details.}

\item{progress.bar}{type of progress bar. Possible values are
    \code{"text"}, \code{"gui"}, and \code{"none"}. See Details.}
}
\description{
Allows to continue sampling from an existing object of class JointAI
}
\examples{
mod <- lm_imp(y~C1 + C2 + M2, data = wideDF, n.iter = 100)
mod_add <- add_samples(mod, n.iter = 200, add = TRUE)

# or to additionally sample imputed values
imps <- add_samples(mod, n.iter = 200, monitor_params = c("imps" = TRUE),
                    add = FALSE)


}
