% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psPoisson.R
\name{psPoisson}
\alias{psPoisson}
\title{Smoothing scattered Poisson data using P-splines.}
\usage{
psPoisson(
  x,
  y,
  xl = min(x),
  xr = max(x),
  nseg = 10,
  bdeg = 3,
  pord = 2,
  lambda = 1,
  wts = NULL,
  show = FALSE,
  iter = 100,
  xgrid = 100
)
}
\arguments{
\item{x}{the vector for the continuous regressor of \code{length(y)} and
the abcissae used to build the B-spline basis.}

\item{y}{the response vector, usually count data.}

\item{xl}{the number for the min along \code{x} (default is min(\code{x})).}

\item{xr}{the number for the max along \code{x} (default is max(\code{x})).}

\item{nseg}{the number of evenly spaced segments between \code{xl} and \code{xr} (default 10).}

\item{bdeg}{the number of the degree of the basis, usually 1, 2, or 3 (defalult).}

\item{pord}{the number of the order of the difference penalty, usually 1, 2 (default), or 3.}

\item{lambda}{the (positive) number for the tuning parameter for the penalty (default 1).}

\item{wts}{the vector of general weights, zeros are allowed (default 1).}

\item{show}{Set to TRUE or FALSE to display iteration history (default FALSE).}

\item{iter}{a scalar to set the maximum number of iterations, default \code{iter=100}.}

\item{xgrid}{a scalar or a vector that gives the \code{x} locations for prediction, useful for plotting.
If a scalar (default 100) is used then a uniform grid of this size along (\code{xl}, \code{xr}).}
}
\value{
\item{pcoef}{a vector of length \code{n} of estimated P-spline coefficients.}
\item{muhat}{a vector of length \code{m} of estimated means.}
\item{B}{the \code{m} by \code{n} B-spline basis.}
\item{dev}{deviance of fit.}
\item{effdim}{effective dimension of fit.}
\item{aic}{AIC.}
\item{wts}{the vector of given prior weights.}
\item{nseg}{the number of B-spline segments.}
\item{bdeg}{the degree of the B-spline basis.}
\item{pord}{the order of the difference penalty.}
\item{lambda}{the positive tuning parameter.}
\item{family}{the family of the response (
\code{"Poisson"}).}
\item{link}{the link function used (\code{"log"}).}
\item{xgrid}{gridded x values, useful for plotting.}
\item{ygrid}{gridded fitted linear predictor values, useful for plotting.}
\item{mugrid}{gridded (inverse link) fitted mean values, useful for plotting.}
\item{se_eta}{gridded standard errors for the linear predictor.}
\item{dispersion}{Dispersion parameter estimated \code{dev/(m-effdim)}.}
}
\description{
\code{psPoisson} is used to smooth scattered
Poisson data using P-splines with a log link function.
}
\examples{
library(JOPS)
library(boot)

# Extract the data
Count <- hist(boot::coal$date, breaks = c(1851:1963), plot = FALSE)$counts
Year <- c(1851:1962)
xl <- min(Year)
xr <- max(Year)

# Poisson smoothing
nseg <- 20
bdeg <- 3
fit1 <- psPoisson(Year, Count, xl, xr, nseg, bdeg, pord = 2, lambda = 1)
plot(fit1, xlab = "Year", ylab = "Count", se = 2)
}
\references{
Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.

Eilers, P.H.C., Marx, B.D., and Durban, M. (2015).
Twenty years of P-splines, \emph{SORT}, 39(2): 149-186.
}
\author{
Paul Eilers and Brian Marx
}
