/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.toolkit.JGRStyledDocument;

public class ConsoleOutput
extends JTextPane {
    private static final long serialVersionUID = -5957720607822410824L;
    private boolean lastLineWasEmpty = false;
    private String prompt = null;
    private String continueS = null;

    public ConsoleOutput() {
        if (FontTracker.current == null) {
            FontTracker.current = new FontTracker();
        }
        FontTracker.current.add(this);
        this.setDocument(new JGRStyledDocument());
    }

    public void startExport() {
        new ExportOutput(this);
    }

    private void exportCommands(File file) {
        this.saveToFile(file, this.getCommands());
    }

    public void copyCommands() {
        try {
            int a = this.getLineOfOffset(this.getSelectionStart());
            int b = this.getLineOfOffset(this.getSelectionEnd());
            if (a == -1 || b == -1) {
                return;
            }
            StringSelection s = new StringSelection(this.getCommands(a, b).toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s, s);
        }
        catch (Exception e) {
            return;
        }
    }

    private StringBuffer getCommands() {
        return this.getCommands(0, this.getLineCount());
    }

    private StringBuffer getCommands(int a, int b) {
        StringBuffer bf = new StringBuffer();
        for (int i = a; i <= b; ++i) {
            try {
                if (!this.isCorrectLine(i) || !this.isCommandLine(i)) continue;
                String l = this.trimFront(this.getLine(i).replaceFirst(this.prompt, ""));
                if (i < this.getLineCount() && this.isCorrectLine(i + 1) && !l.startsWith("#")) {
                    bf.append(l);
                    continue;
                }
                if (i < this.getLineCount() && !this.isCorrectLine(i + 1) && l.startsWith(this.continueS)) {
                    bf.append(l);
                    continue;
                }
                if (i == this.getLineCount() && !l.startsWith("#")) {
                    bf.append(l);
                    continue;
                }
                if (i != b) continue;
                bf.append(l);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return bf;
    }

    private void exportOutput(File file) {
        this.saveToFile(file, this.getOutput());
    }

    public void copyOutput() {
        try {
            int a = this.getLineOfOffset(this.getSelectionStart());
            int b = this.getLineOfOffset(this.getSelectionEnd());
            if (a == -1 || b == -1) {
                return;
            }
            StringSelection s = new StringSelection(this.getOutput(a, b).toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s, s);
        }
        catch (Exception e) {
            return;
        }
    }

    private StringBuffer getOutput() {
        return this.getOutput(0, this.getLineCount());
    }

    private StringBuffer getOutput(int a, int b) {
        StringBuffer bf = new StringBuffer();
        for (int i = a; i <= b; ++i) {
            try {
                if (!this.isCorrectLine(i)) continue;
                bf.append(this.getLine(i));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bf;
    }

    private void exportResult(File file) {
        this.saveToFile(file, this.getResult());
    }

    public void copyResults() {
        try {
            int a = this.getLineOfOffset(this.getSelectionStart());
            int b = this.getLineOfOffset(this.getSelectionEnd());
            if (a == -1 || b == -1) {
                return;
            }
            StringSelection s = new StringSelection(this.getResult(a, b).toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s, s);
        }
        catch (Exception e) {
            return;
        }
    }

    private StringBuffer getResult() {
        return this.getResult(0, this.getLineCount());
    }

    private StringBuffer getResult(int a, int b) {
        StringBuffer bf = new StringBuffer();
        for (int i = a; i <= b; ++i) {
            try {
                if (!this.isCorrectLine(i)) continue;
                if (this.isResultLine(i)) {
                    String line = this.getLine(i);
                    if (line.trim().startsWith("Error")) continue;
                    bf.append(this.getLine(i));
                    this.lastLineWasEmpty = false;
                    continue;
                }
                if (!this.lastLineWasEmpty) {
                    bf.append("\n");
                }
                this.lastLineWasEmpty = true;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return bf;
    }

    private boolean isCommandLine(int i) throws BadLocationException {
        String line;
        if (this.prompt == null) {
            this.prompt = RController.getRPrompt();
        }
        if (this.continueS == null) {
            this.continueS = RController.getRContinue();
        }
        if ((line = this.getLine(i)).equals(this.prompt.trim())) {
            return false;
        }
        return line.trim().startsWith(this.prompt.trim()) || line.trim().startsWith(this.continueS.trim());
    }

    private boolean isResultLine(int i) throws BadLocationException {
        String line;
        if (this.prompt == null) {
            this.prompt = RController.getRPrompt();
        }
        if (this.continueS == null) {
            this.continueS = RController.getRContinue();
        }
        return !(line = this.getLine(i)).trim().startsWith(this.prompt.trim()) && !line.trim().startsWith(this.continueS.trim());
    }

    private boolean isCorrectLine(int i) {
        if (this.prompt == null) {
            this.prompt = RController.getRPrompt();
        }
        if (this.continueS == null) {
            this.continueS = RController.getRContinue();
        }
        return !this.getLine(i).trim().equals(this.prompt.trim()) && !this.getLine(i).trim().startsWith("Error");
    }

    private String trimFront(String s) {
        s = s.replaceFirst("\\s*", "");
        return s;
    }

    public String getLine(int i) {
        String line = null;
        try {
            int s = this.getLineStartOffset(i);
            int e = this.getLineEndOffset(i);
            line = this.getText(s, e - s);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(File file, StringBuffer bf) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(bf.toString());
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(JGR.MAINRCONSOLE, "Permisson denied", "File Error", 0);
        }
    }

    public String getText() {
        try {
            Document doc = this.getDocument();
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public String getText(int offs, int len) {
        try {
            Document doc = this.getDocument();
            return doc.getText(0, doc.getLength()).substring(offs, offs + len);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public void append(String str, AttributeSet a) {
        Document doc = this.getDocument();
        if (doc != null) {
            try {
                doc.insertString(doc.getLength(), str, a);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
    }

    public int getLineCount() {
        Element map = this.getDocument().getDefaultRootElement();
        return map.getElementCount();
    }

    public int getLineStartOffset(int line) throws BadLocationException {
        int lineCount = this.getLineCount();
        if (line < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (line >= lineCount) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element map = this.getDocument().getDefaultRootElement();
        Element lineElem = map.getElement(line);
        return lineElem.getStartOffset();
    }

    public int getLineEndOffset(int line) throws BadLocationException {
        int lineCount = this.getLineCount();
        if (line < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (line >= lineCount) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element map = this.getDocument().getDefaultRootElement();
        Element lineElem = map.getElement(line);
        int endOffset = lineElem.getEndOffset();
        return line == lineCount - 1 ? endOffset - 1 : endOffset;
    }

    public int getLineOfOffset(int offset) throws BadLocationException {
        Document doc = this.getDocument();
        if (offset < 0) {
            throw new BadLocationException("Can't translate offset to line", -1);
        }
        if (offset > doc.getLength()) {
            throw new BadLocationException("Can't translate offset to line", doc.getLength() + 1);
        }
        Element map = this.getDocument().getDefaultRootElement();
        return map.getElementIndex(offset);
    }

    public void removeAllFrom(int index) throws BadLocationException {
        this.getDocument().remove(index, this.getDocument().getLength() - index);
    }

    public void setFont(Font f) {
        super.setFont(f);
        try {
            ((StyledDocument)this.getDocument()).setCharacterAttributes(0, this.getText().length(), JGRPrefs.SIZE, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class ExportOutput
    extends JFileChooser
    implements ActionListener {
        private static final long serialVersionUID = 5513930176299068347L;
        private final JRadioButton wholeOutput;
        private final JRadioButton cmdsOutput;
        private final JRadioButton resultOutput;
        private ConsoleOutput out;

        public ExportOutput(ConsoleOutput co) {
            super(JGRPrefs.workingDirectory);
            this.wholeOutput = new JRadioButton("Complete Output", true);
            this.cmdsOutput = new JRadioButton("Commands", false);
            this.resultOutput = new JRadioButton("Results", false);
            this.out = co;
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.wholeOutput);
            bg.add(this.cmdsOutput);
            bg.add(this.resultOutput);
            this.addActionListener(this);
            if (System.getProperty("os.name").startsWith("Window")) {
                JPanel fileview = (JPanel)((JComponent)((JComponent)this.getComponent(2)).getComponent(2)).getComponent(2);
                JPanel options = new JPanel(new FlowLayout(0));
                options.add(new JLabel("Options: "));
                options.add(this.wholeOutput);
                options.add(this.cmdsOutput);
                options.add(this.resultOutput);
                fileview.add(options);
                JPanel pp = (JPanel)((JComponent)((JComponent)this.getComponent(2)).getComponent(2)).getComponent(0);
                pp.add(new JPanel());
            } else {
                JPanel filename = (JPanel)this.getComponent(this.getComponentCount() - 1);
                JPanel options = new JPanel(new FlowLayout(0));
                options.add(new JLabel("Options: "));
                options.add(this.wholeOutput);
                options.add(this.cmdsOutput);
                options.add(this.resultOutput);
                filename.add((Component)options, filename.getComponentCount() - 1);
            }
            this.showSaveDialog(co);
        }

        public void export(File file) {
            if (this.wholeOutput.isSelected()) {
                this.out.exportOutput(file);
            } else if (this.cmdsOutput.isSelected()) {
                this.out.exportCommands(file);
            } else if (this.resultOutput.isSelected()) {
                this.out.exportResult(file);
            }
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd == "ApproveSelection") {
                this.export(this.getSelectedFile());
            }
        }
    }
}

