/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.util.Global;
import org.rosuda.util.ProgressDlg;
import org.rosuda.util.Stopwatch;

public class SVarObj
extends SVar {
    List cont;
    List cats;
    List ccnts;
    int[] ranks = null;
    boolean muteNotify = false;

    public SVarObj(String Name, boolean iscat) {
        super(Name, iscat);
        this.isnum = false;
        this.contentsType = 0;
        this.cont = new ArrayList();
        if (iscat) {
            this.cats = new ArrayList();
            this.ccnts = new ArrayList();
        }
    }

    public SVarObj(String Name, boolean isnum, boolean iscat) {
        super(Name, isnum, iscat);
        this.guessing = false;
        this.cont = new ArrayList();
        if (iscat) {
            this.cats = new ArrayList();
            this.ccnts = new ArrayList();
        }
    }

    public SVarObj(String Name) {
        this(Name, false);
    }

    public void setAllEmpty(int size) {
        for (int i = 0; i < size; ++i) {
            ++this.missingCount;
            this.cont.add(this.cat ? "NA" : null);
        }
        if (this.cat) {
            this.categorize(true);
        }
    }

    public String[] getContent() {
        String[] content = new String[this.cont.size()];
        ListIterator e = this.cont.listIterator();
        for (int i = 0; e.hasNext() && i < content.length; ++i) {
            Object o = e.next();
            content[i] = o != null ? o.toString() : "NA";
        }
        return content;
    }

    public void tryToGuessNum(boolean doit) {
        this.guessing = doit;
    }

    public int size() {
        return this.cont.size();
    }

    public void categorize(boolean rebuild) {
        if (this.cat && !rebuild) {
            return;
        }
        this.cats = new ArrayList();
        this.ccnts = new ArrayList();
        this.cat = true;
        if (!this.isEmpty()) {
            ListIterator e = this.cont.listIterator();
            while (e.hasNext()) {
                int i;
                Object oo = e.next();
                if (oo == null) {
                    oo = "NA";
                }
                if ((i = this.cats.indexOf(oo)) == -1) {
                    this.cats.add(oo);
                    this.ccnts.add(new Integer(1));
                    continue;
                }
                this.ccnts.set(i, new Integer((Integer)this.ccnts.get(i) + 1));
            }
            if (this.isNum()) {
                this.sortCategories();
            }
        }
        if (!this.muteNotify) {
            this.NotifyAll(new NotifyMsg(this, 12290));
        }
    }

    public void sortCategories(int method) {
        if (!this.isCat() || this.cats.size() < 2) {
            return;
        }
        Stopwatch sw = null;
        if (Global.DEBUG > 0) {
            sw = new Stopwatch();
            System.out.println("Sorting variable \"" + this.name + "\"");
        }
        List ocats = this.cats;
        List occnts = this.ccnts;
        this.cats = new ArrayList(ocats.size());
        this.ccnts = new ArrayList(occnts.size());
        boolean found = true;
        int cs = ocats.size();
        while (found) {
            found = false;
            int p = -1;
            double min = -0.01;
            boolean gotmin = false;
            String mino = null;
            for (int i = 0; i < cs; ++i) {
                Object o = ocats.get(i);
                if (o == null) continue;
                if (method == 1) {
                    double val = -0.01;
                    try {
                        val = ((Number)o).doubleValue();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!gotmin) {
                        gotmin = true;
                        min = val;
                        p = i;
                        continue;
                    }
                    if (!(val < min)) continue;
                    min = val;
                    p = i;
                    continue;
                }
                if (!gotmin) {
                    gotmin = true;
                    mino = o.toString();
                    p = i;
                    continue;
                }
                if (mino.compareTo(o.toString()) <= 0) continue;
                mino = o.toString();
                p = i;
            }
            found = gotmin;
            if (!found) continue;
            this.cats.add(ocats.get(p));
            this.ccnts.add(occnts.get(p));
            ocats.set(p, null);
        }
        if (Global.DEBUG > 0) {
            sw.profile("sorted");
        }
    }

    public void dropCat() {
        this.cats = null;
        this.ccnts = null;
        this.cat = false;
        if (!this.muteNotify) {
            this.NotifyAll(new NotifyMsg(this, 12290));
        }
    }

    public void setCategorical(boolean nc) {
        if (!nc) {
            this.cat = false;
        } else if (this.cats == null) {
            this.categorize();
        } else {
            this.cat = true;
        }
    }

    public boolean add(Object o) {
        if (this.cacheRanks && this.ranks != null) {
            this.ranks = null;
        }
        if (o == null) {
            ++this.missingCount;
        }
        if (o != null && this.size() == this.missingCount && this.guessing) {
            try {
                if (Class.forName("java.lang.Number").isAssignableFrom(o.getClass())) {
                    this.isnum = true;
                    this.contentsType = 1;
                }
            }
            catch (Exception E) {
                // empty catch block
            }
            if (this.isnum) {
                this.min = this.max = ((Number)o).doubleValue();
            }
        }
        if (this.cat) {
            int i;
            Object oo = o;
            if (o == null) {
                oo = "NA";
            }
            if ((i = this.cats.indexOf(oo)) == -1) {
                this.cats.add(oo);
                this.ccnts.add(new Integer(1));
            } else {
                this.ccnts.set(i, new Integer((Integer)this.ccnts.get(i) + 1));
            }
        }
        if (this.isnum && o != null) {
            try {
                double val = ((Number)o).doubleValue();
                if (val > this.max) {
                    this.max = val;
                }
                if (val < this.min) {
                    this.min = val;
                }
            }
            catch (Exception E) {
                return false;
            }
        }
        this.cont.add(o);
        if (!this.muteNotify) {
            this.NotifyAll(new NotifyMsg(this, 12289));
        }
        return true;
    }

    public boolean insert(Object o, int index) {
        if (o != null) {
            int insp = this.size();
            boolean savedMuteNotify = this.muteNotify;
            this.muteNotify = true;
            if (!this.add(o)) {
                this.muteNotify = savedMuteNotify;
                return false;
            }
            this.cont.add(index, o);
            this.cont.remove(insp);
            this.muteNotify = savedMuteNotify;
            if (!this.muteNotify) {
                this.NotifyAll(new NotifyMsg(this, 12289));
            }
            return true;
        }
        if (this.cacheRanks && this.ranks != null) {
            this.ranks = null;
        }
        ++this.missingCount;
        this.cont.add(index, null);
        if (!this.muteNotify) {
            this.NotifyAll(new NotifyMsg(this, 12289));
        }
        return true;
    }

    public boolean remove(int index) {
        Object o = this.at(index);
        if (o == null && this.missingCount > -1) {
            --this.missingCount;
        }
        this.cont.remove(index);
        if (this.cats != null) {
            this.categorize(true);
        }
        return true;
    }

    public boolean replace(int i, Object o) {
        if (i < 0 || i >= this.size()) {
            return false;
        }
        Object oo = this.at(i);
        if (oo == o) {
            return true;
        }
        if (oo == null) {
            --this.missingCount;
        }
        if (o == null) {
            ++this.missingCount;
        }
        if (this.isnum && o != null) {
            try {
                double val = ((Number)o).doubleValue();
                if (val > this.max) {
                    this.max = val;
                }
                if (val < this.min) {
                    this.min = val;
                }
            }
            catch (Exception E) {
                return false;
            }
        }
        this.cont.set(i, o);
        if (!this.muteNotify) {
            this.NotifyAll(new NotifyMsg(this, 12289));
        }
        if (this.cat) {
            this.categorize(true);
        }
        return true;
    }

    public Object at(int i) {
        return this.cont.get(i);
    }

    public int getCatIndex(Object o) {
        if (this.cats == null) {
            return -1;
        }
        Object oo = o;
        if (o == null) {
            oo = "NA";
        }
        return this.cats.indexOf(oo);
    }

    public int getCatIndex(int i) {
        try {
            return this.getCatIndex(this.elementAt(i));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public Object getCatAt(int i) {
        if (this.cats == null) {
            return null;
        }
        try {
            return this.cats.get(i);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getSizeCatAt(int i) {
        if (this.cats == null) {
            return -1;
        }
        try {
            return (Integer)this.ccnts.get(i);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int getSizeCat(Object o) {
        if (this.cats == null) {
            return -1;
        }
        int i = this.cats.indexOf(o);
        return i == 1 ? -1 : (Integer)this.ccnts.get(i);
    }

    public int getNumCats() {
        if (this.cats == null) {
            return 0;
        }
        return this.cats.size();
    }

    public Object[] getCategories() {
        if (this.cats == null) {
            return null;
        }
        Object[] c = new Object[this.cats.size()];
        this.cats.toArray(c);
        return c;
    }

    public int[] getRanked(SMarker m, int markspec) {
        int ct;
        Stopwatch sw = new Stopwatch();
        if (this.isCat() || !this.isNum() || this.size() == 0) {
            return null;
        }
        if (m == null && this.cacheRanks && this.ranks != null) {
            return this.ranks;
        }
        int[] r = null;
        if (!this.cacheRanks || this.ranks == null) {
            if (this.size() < 1000) {
                int i;
                int ct2 = this.size();
                if (ct2 == 0) {
                    return null;
                }
                r = new int[ct2];
                for (i = 0; i < ct2; ++i) {
                    r[i] = i;
                }
                sw.profile("getRanked: prepare");
                for (i = 0; i < ct2 - 1; ++i) {
                    double d = this.atD(r[i]);
                    for (int j = ct2 - 1; j > i; --j) {
                        double d2 = this.atD(r[j]);
                        if (!(d2 < d)) continue;
                        int xx = r[i];
                        r[i] = r[j];
                        r[j] = xx;
                        d = d2;
                    }
                }
                sw.profile("getRanked: sort");
                if (this.cacheRanks) {
                    this.ranks = r;
                }
            } else {
                int i;
                ProgressDlg pd = new ProgressDlg("Variable " + this.getName());
                pd.begin("Calculating ranks ...");
                ct = this.size();
                r = new int[ct];
                double[] da = new double[ct];
                sw.profile("getRanked: alloc double array for " + ct + " cases");
                for (i = 0; i < ct; ++i) {
                    r[i] = i;
                    da[i] = this.atD(i);
                }
                sw.profile("getRanked: pass 2: store relevant values");
                for (i = 0; i < ct - 1; ++i) {
                    double d = da[r[i]];
                    int j = ct - 1;
                    if ((i & 0xFF) == 0) {
                        pd.setProgress((int)((double)i * 99.0 / (double)ct));
                    }
                    while (j > i) {
                        double d2 = da[r[j]];
                        if (d2 < d) {
                            int xx = r[i];
                            r[i] = r[j];
                            r[j] = xx;
                            d = d2;
                        }
                        --j;
                    }
                }
                pd.setProgress(99);
                sw.profile("getRanked: pass 3: sort");
                if (this.cacheRanks) {
                    this.ranks = r;
                }
                da = null;
                pd.end();
                pd = null;
            }
        } else {
            r = this.ranks;
        }
        if (m != null && r != null) {
            int i;
            int x = r.length;
            ct = 0;
            for (i = 0; i < x; ++i) {
                if (m.get(i) != markspec) continue;
                ++ct;
            }
            if (ct == 0) {
                return null;
            }
            int[] mr = new int[ct];
            int mri = 0;
            for (i = 0; i < x; ++i) {
                if (m.get(r[i]) != markspec) continue;
                mr[mri++] = r[i];
            }
            r = null;
            r = mr;
        }
        return r;
    }

    public String toString() {
        return "SVarObj(\"" + this.name + "\"," + (this.cat ? "cat," : "cont,") + (this.isnum ? "num," : "txt,") + "n=" + this.size() + ",miss=" + this.missingCount + ")";
    }
}

