/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.ibase.Common;

public class FileSelector
extends JFrame {
    public static final int OPEN = 0;
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    private static final long serialVersionUID = 7010137219452461372L;
    public static String lastDirectory = JGRPrefs.workingDirectory;
    private FileDialog awtDialog = null;
    private JFileChooser swingChooser = null;
    private int type = 0;
    private Frame f;
    private int result = 1;
    private boolean isSwing = false;

    public FileSelector(Frame f, String title, int type, String directory) {
        this(f, title, type, directory, false);
    }

    public FileSelector(Frame f, String title, int type, String directory, boolean forceSwing) {
        this.type = type;
        this.f = f;
        if (Common.isMac() && !forceSwing) {
            this.awtDialog = new FileDialog(f, title, type);
            if (directory != null) {
                this.awtDialog.setDirectory(directory);
            } else if (lastDirectory != null) {
                this.awtDialog.setDirectory(lastDirectory);
            }
            this.isSwing = false;
        } else {
            if (directory != null) {
                this.swingChooser = new JFileChooser(directory);
            } else if (lastDirectory != null) {
                this.swingChooser = new JFileChooser(lastDirectory);
            }
            this.swingChooser.setDialogTitle(title);
            this.swingChooser.setFileHidingEnabled(!JGRPrefs.showHiddenFiles);
            this.isSwing = true;
        }
    }

    public FileSelector(Frame f, String title, int type) {
        this(f, title, type, null, false);
    }

    public void addActionListener(ActionListener al) {
        if (this.isSwing) {
            this.swingChooser.addActionListener(al);
        }
    }

    public void setVisible(boolean b) {
        if (!this.isSwing) {
            this.awtDialog.setVisible(true);
        } else {
            this.result = this.type == 0 ? this.swingChooser.showOpenDialog(this.f) : (this.type == 1 ? this.swingChooser.showSaveDialog(this.f) : this.swingChooser.showDialog(this.f, "OK"));
        }
    }

    public String getFile() {
        String fileName = null;
        try {
            if (!this.isSwing) {
                fileName = this.awtDialog.getFile();
                lastDirectory = this.awtDialog.getDirectory();
            } else {
                if (this.result == 1) {
                    return null;
                }
                fileName = this.swingChooser.getSelectedFile().getName();
                lastDirectory = this.swingChooser.getCurrentDirectory().getAbsolutePath() + File.separator;
            }
            return fileName;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setFile(String file) {
        try {
            if (!this.isSwing) {
                this.awtDialog.setFile(file);
            } else {
                this.swingChooser.setSelectedFile(new File(file));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public File getSelectedFile() {
        if (this.isSwing) {
            return this.swingChooser.getSelectedFile();
        }
        return new File(this.awtDialog.getFile());
    }

    public String getDirectory() {
        try {
            if (!this.isSwing) {
                lastDirectory = this.awtDialog.getDirectory();
                return lastDirectory;
            }
            lastDirectory = this.swingChooser.getCurrentDirectory().getAbsolutePath() + File.separator;
            return lastDirectory;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void addFooterPanel(JPanel panel) {
        Container fileView = null;
        try {
            if (this.isSwing) {
                fileView = System.getProperty("os.name").startsWith("Window") ? (JPanel)((JComponent)((JComponent)this.swingChooser.getComponent(2)).getComponent(2)).getComponent(2) : (JPanel)this.swingChooser.getComponent(this.swingChooser.getComponentCount() - 1);
            }
            if (fileView != null) {
                fileView.add(panel);
                if (System.getProperty("os.name").startsWith("Window")) {
                    JPanel pp = (JPanel)((JComponent)((JComponent)this.swingChooser.getComponent(2)).getComponent(2)).getComponent(0);
                    JPanel temp = new JPanel();
                    temp.setMaximumSize(new Dimension(0, panel.getPreferredSize().height));
                    pp.add(temp);
                }
            }
        }
        catch (Exception e) {
            new ErrorMsg(e);
        }
    }

    public boolean isSwing() {
        return this.isSwing;
    }

    public Component getSelector() {
        if (!this.isSwing) {
            return this.awtDialog;
        }
        return this.swingChooser;
    }

    public JFileChooser getJFileChooser() {
        return this.swingChooser;
    }

    public FileDialog getAWTChooser() {
        return this.awtDialog;
    }
}

