/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.toolkit.ExtensionFileFilter;
import org.rosuda.JGR.toolkit.JComboBoxExt;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

public class JGRDataFileOpenDialog
extends JFileChooser
implements ActionListener,
ItemListener,
PropertyChangeListener {
    private static final long serialVersionUID = 2438253324279973086L;
    public static String[][] extensions = new String[][]{{"rda", "rdata"}, {"csv"}, {"txt"}};
    public static String[] extensionDescription = new String[]{"R (*.rda *.rdata)", "Comma seperated (*.csv)", "Text file (*.txt)"};
    private final JTextField dataName = new JTextField();
    private final JCheckBox header = new JCheckBox("Header", true);
    private final JCheckBox attach = new JCheckBox("Attach", false);
    private final JComboBoxExt sepsBox = new JComboBoxExt(new String[]{"\\t", "\\w", ",", ";", "|", "Others..."});
    private final String[] seps = new String[]{"\\t", "", ",", ";", "|"};
    private final JComboBoxExt quoteBox = new JComboBoxExt(new String[]{"None", "\\\"", "\\'", "Others..."});
    private final String[] quotes = new String[]{"", "\\\"", "\\'"};
    private boolean nameAccepted = false;

    public JGRDataFileOpenDialog(Frame frame, String string) {
        this.setFileHidingEnabled(!JGRPrefs.showHiddenFiles);
        this.addActionListener(this);
        this.addPropertyChangeListener(this);
        if (string != null && new File(string).exists()) {
            this.setCurrentDirectory(new File(string));
        }
        for (int i = 0; i < extensionDescription.length; ++i) {
            ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(extensionDescription[i], extensions[i]);
            this.addChoosableFileFilter(extensionFileFilter);
        }
        this.setFileFilter(this.getAcceptAllFileFilter());
        this.showOpenDialog(frame);
    }

    public void loadFile() {
        if (this.getSelectedFile() != null) {
            JGRPrefs.workingDirectory = this.getCurrentDirectory().getAbsolutePath() + File.separator;
            String string = this.getSelectedFile().toString();
            String string2 = this.sepsBox.getSelectedIndex() >= this.seps.length ? this.sepsBox.getSelectedItem().toString() : this.seps[this.sepsBox.getSelectedIndex()];
            String string3 = this.quoteBox.getSelectedIndex() >= this.quotes.length ? this.quoteBox.getSelectedItem().toString() : this.quotes[this.quoteBox.getSelectedIndex()];
            String string4 = this.dataName.getText().trim().replaceAll("\\s", "") + " <- read.table(\"" + string.replace('\\', '/') + "\",header=" + (this.header.isSelected() ? "T" : "F") + ",sep=\"" + string2 + "\", quote=\"" + string3 + "\")" + (this.attach.isSelected() ? ";attach(" + this.dataName.getText().trim().replaceAll("\\s", "") + ")" : "") + "";
            JGR.MAINRCONSOLE.execute(string4, true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        String string2 = this.getSelectedFile().toString();
        if (string == "ApproveSelection" && (string2.endsWith(".rda") || string2.endsWith(".rdata"))) {
            this.loadRdaFile(string2);
        }
    }

    public void loadRdaFile(String string) {
        String string2 = "dataset<-load(\"" + string.replace('\\', '/') + "\")";
        JGR.MAINRCONSOLE.execute(string2, true);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        boolean bl = false;
        if (itemSelectable == this.quoteBox) {
            bl = this.quoteBox.getSelectedIndex() == this.quoteBox.getItemCount() - 1;
            this.quoteBox.setEditable(bl);
        } else if (itemSelectable == this.sepsBox) {
            bl = this.sepsBox.getSelectedIndex() == this.sepsBox.getItemCount() - 1;
            this.sepsBox.setEditable(bl);
        }
    }

    private void checkFile(File file) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            String string2 = null;
            if (bufferedReader.ready()) {
                string = bufferedReader.readLine();
            }
            if (bufferedReader.ready()) {
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            if (string2 != null) {
                int n = string2.indexOf("\"");
                if (n > -1 && string2.indexOf("\"", n + 1) > -1) {
                    this.quoteBox.setSelectedItem("\\\"");
                } else {
                    n = string2.indexOf("'");
                    if (n > -1 && string2.indexOf("'", n + 1) > -1) {
                        this.quoteBox.setSelectedItem("\\'");
                    } else {
                        this.quoteBox.setSelectedItem("None");
                    }
                }
                this.sepsBox.setSelectedItem("\\w");
                n = string2.indexOf("\t");
                if (n > -1 && string2.indexOf("\t", n + 1) > -1) {
                    this.sepsBox.setSelectedItem("\\t");
                }
                if ((n = string2.indexOf(";")) > -1 && string2.indexOf(";", n + 1) > -1) {
                    this.sepsBox.setSelectedItem(";");
                }
                if ((n = string2.indexOf(",")) > -1 && string2.indexOf(",", n + 1) > -1) {
                    this.sepsBox.setSelectedItem(",");
                }
                if ((n = string2.indexOf("|")) > -1 && string2.indexOf("|", n + 1) > -1) {
                    this.sepsBox.setSelectedItem("|");
                }
                if ((n = string2.indexOf("\\w")) == string2.indexOf("\n")) {
                    this.sepsBox.setSelectedItem("\\t");
                }
            }
            if (string != null && string2 != null) {
                String string3 = this.seps[this.sepsBox.getSelectedIndex()];
                string3 = string3 == "\\t" ? "\t" : string3;
                int n = 0;
                int n2 = 0;
                if (string3.length() == 0) {
                    n = new StringTokenizer(string).countTokens();
                    n2 = new StringTokenizer(string2).countTokens();
                } else {
                    int n3 = -1;
                    while ((n3 = string.trim().indexOf(string3, n3 + 1)) > -1) {
                        ++n;
                    }
                    n3 = -1;
                    while ((n3 = string2.trim().indexOf(string3, n3 + 1)) > -1) {
                        ++n2;
                    }
                }
                if (n + 1 == n2 || n == n2 && string.matches("^[a-zA-Z\"].*")) {
                    this.header.setSelected(true);
                } else {
                    this.header.setSelected(false);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        File file = this.getSelectedFile();
        if (file != null && !file.isDirectory() && !this.nameAccepted) {
            String string = file.getName().replaceAll("\\..*", "");
            string = string.replaceAll("^[0-9]+|[^a-zA-Z|^0-9|^_]", ".");
            try {
                REXP rEXP = JGR.idleEval("try(.refreshObjects(),silent=TRUE)");
                String[] stringArray = null;
                if (rEXP != null && (stringArray = rEXP.asStrings()) != null) {
                    JGR.setObjects(stringArray);
                }
                while (JGR.OBJECTS.contains(string) && !this.nameAccepted) {
                    String string2 = (String)JOptionPane.showInputDialog(new JTextField(), "Object name already used!", "Object " + string + " exists!", -1, null, null, string);
                    if (string2 != null) {
                        string = string2;
                    }
                    this.nameAccepted = true;
                }
                this.dataName.setText(string);
            }
            catch (REngineException rEngineException) {
                new ErrorMsg(rEngineException);
            }
            catch (REXPMismatchException rEXPMismatchException) {
                new ErrorMsg(rEXPMismatchException);
            }
            this.checkFile(file);
        } else {
            this.dataName.setText(null);
        }
    }
}

