/*
 * Decompiled with CFR 0.152.
 */
package jedit.syntax;

import javax.swing.text.Segment;
import jedit.syntax.KeywordMap;
import jedit.syntax.SyntaxUtilities;
import jedit.syntax.TokenMarker;

public class PerlTokenMarker
extends TokenMarker {
    public static final byte S_ONE = 100;
    public static final byte S_TWO = 101;
    public static final byte S_END = 102;
    private KeywordMap keywords;
    private byte token;
    private int lastOffset;
    private int lastKeyword;
    private char matchChar;
    private boolean matchCharBracket;
    private boolean matchSpacesAllowed;
    private static KeywordMap perlKeywords;

    public PerlTokenMarker() {
        this(PerlTokenMarker.getKeywords());
    }

    public PerlTokenMarker(KeywordMap keywordMap) {
        this.keywords = keywordMap;
    }

    public byte markTokensImpl(byte by, Segment segment, int n) {
        char[] cArray = segment.array;
        int n2 = segment.offset;
        this.token = by;
        this.lastOffset = n2;
        this.lastKeyword = n2;
        this.matchChar = '\u0000';
        this.matchCharBracket = false;
        this.matchSpacesAllowed = false;
        int n3 = segment.count + n2;
        if (this.token == 3 && n != 0 && this.lineInfo[n - 1].obj != null) {
            String string = (String)this.lineInfo[n - 1].obj;
            if (string != null && string.length() == segment.count && SyntaxUtilities.regionMatches(false, segment, n2, string)) {
                this.addToken(segment.count, this.token);
                return 0;
            }
            this.addToken(segment.count, this.token);
            this.lineInfo[n].obj = string;
            return this.token;
        }
        boolean bl = false;
        block37: for (int i = n2; i < n3; ++i) {
            int n4 = i + 1;
            char c = cArray[i];
            if (c == '\\') {
                bl = !bl;
                continue;
            }
            switch (this.token) {
                case 0: {
                    switch (c) {
                        case '#': {
                            if (this.doKeyword(segment, i, c)) break;
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, this.token);
                            this.addToken(n3 - i, (byte)1);
                            this.lastOffset = this.lastKeyword = n3;
                            break block37;
                        }
                        case '=': {
                            bl = false;
                            if (i == n2) {
                                this.token = (byte)2;
                                this.addToken(n3 - i, this.token);
                                this.lastOffset = this.lastKeyword = n3;
                                break block37;
                            }
                            this.doKeyword(segment, i, c);
                            break;
                        }
                        case '$': 
                        case '%': 
                        case '&': 
                        case '@': {
                            bl = false;
                            if (this.doKeyword(segment, i, c)) break;
                            if (n3 - i <= 1) continue block37;
                            if (c == '&' && (cArray[n4] == '&' || Character.isWhitespace(cArray[n4]))) {
                                ++i;
                                break;
                            }
                            this.addToken(i - this.lastOffset, this.token);
                            this.lastOffset = this.lastKeyword = i;
                            this.token = (byte)7;
                            break;
                        }
                        case '\"': {
                            if (this.doKeyword(segment, i, c)) break;
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, this.token);
                            this.token = (byte)3;
                            this.lineInfo[n].obj = null;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            if (bl) {
                                bl = false;
                                break;
                            }
                            int n5 = this.lastKeyword;
                            if (this.doKeyword(segment, i, c) || i != n5) break;
                            this.addToken(i - this.lastOffset, this.token);
                            this.token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '`': {
                            if (this.doKeyword(segment, i, c)) break;
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, this.token);
                            this.token = (byte)9;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '<': {
                            if (this.doKeyword(segment, i, c)) break;
                            if (bl) {
                                bl = false;
                                break;
                            }
                            if (n3 - i <= 2 || cArray[n4] != '<' || Character.isWhitespace(cArray[i + 2])) continue block37;
                            this.addToken(i - this.lastOffset, this.token);
                            this.lastOffset = this.lastKeyword = i;
                            this.token = (byte)3;
                            int n5 = n3 - (i + 2);
                            if (cArray[n3 - 1] == ';') {
                                --n5;
                            }
                            this.lineInfo[n].obj = this.createReadinString(cArray, i + 2, n5);
                            break;
                        }
                        case ':': {
                            bl = false;
                            if (this.doKeyword(segment, i, c) || this.lastKeyword != 0) break;
                            this.addToken(n4 - this.lastOffset, (byte)5);
                            this.lastOffset = this.lastKeyword = n4;
                            break;
                        }
                        case '-': {
                            bl = false;
                            if (this.doKeyword(segment, i, c)) break;
                            if (i != this.lastKeyword) continue block37;
                            if (n3 - i <= 1) break;
                            switch (cArray[n4]) {
                                case 'A': 
                                case 'B': 
                                case 'C': 
                                case 'M': 
                                case 'O': 
                                case 'R': 
                                case 'S': 
                                case 'T': 
                                case 'W': 
                                case 'X': 
                                case 'b': 
                                case 'c': 
                                case 'd': 
                                case 'e': 
                                case 'f': 
                                case 'g': 
                                case 'k': 
                                case 'l': 
                                case 'o': 
                                case 'p': 
                                case 'r': 
                                case 's': 
                                case 't': 
                                case 'u': 
                                case 'w': 
                                case 'x': 
                                case 'z': {
                                    this.addToken(i - this.lastOffset, this.token);
                                    this.addToken(2, (byte)8);
                                    this.lastOffset = this.lastKeyword = i + 2;
                                    ++i;
                                }
                            }
                            break;
                        }
                        case '/': 
                        case '?': {
                            if (this.doKeyword(segment, i, c)) break;
                            if (n3 - i <= 1) continue block37;
                            bl = false;
                            int n5 = cArray[n4];
                            if (Character.isWhitespace((char)n5)) break;
                            this.matchChar = c;
                            this.matchSpacesAllowed = false;
                            this.addToken(i - this.lastOffset, this.token);
                            this.token = (byte)100;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        default: {
                            bl = false;
                            if (Character.isLetterOrDigit(c) || c == '_') continue block37;
                            this.doKeyword(segment, i, c);
                            break;
                        }
                    }
                    continue block37;
                }
                case 7: {
                    bl = false;
                    if (Character.isLetterOrDigit(c) || c == '_' || c == '#' || c == '\'' || c == ':' || c == '&') continue block37;
                    if (i != n2 && cArray[i - 1] == '$') {
                        this.addToken(n4 - this.lastOffset, this.token);
                        this.lastOffset = this.lastKeyword = n4;
                        continue block37;
                    }
                    this.addToken(i - this.lastOffset, this.token);
                    this.lastOffset = this.lastKeyword = i--;
                    this.token = 0;
                    continue block37;
                }
                case 100: 
                case 101: {
                    if (bl) {
                        bl = false;
                        continue block37;
                    }
                    if (this.matchChar == '\u0000') {
                        if (Character.isWhitespace(this.matchChar) && !this.matchSpacesAllowed) continue block37;
                        this.matchChar = c;
                        continue block37;
                    }
                    switch (this.matchChar) {
                        case '(': {
                            this.matchChar = (char)41;
                            this.matchCharBracket = true;
                            break;
                        }
                        case '[': {
                            this.matchChar = (char)93;
                            this.matchCharBracket = true;
                            break;
                        }
                        case '{': {
                            this.matchChar = (char)125;
                            this.matchCharBracket = true;
                            break;
                        }
                        case '<': {
                            this.matchChar = (char)62;
                            this.matchCharBracket = true;
                            break;
                        }
                        default: {
                            this.matchCharBracket = false;
                        }
                    }
                    if (c != this.matchChar) continue block37;
                    if (this.token == 101) {
                        this.token = (byte)100;
                        if (!this.matchCharBracket) continue block37;
                        this.matchChar = '\u0000';
                        continue block37;
                    }
                    this.token = (byte)102;
                    this.addToken(n4 - this.lastOffset, (byte)4);
                    this.lastOffset = this.lastKeyword = n4;
                    continue block37;
                }
                case 102: {
                    bl = false;
                    if (Character.isLetterOrDigit(c) || c == '_') continue block37;
                    this.doKeyword(segment, i, c);
                    continue block37;
                }
                case 2: {
                    bl = false;
                    if (i != n2) continue block37;
                    this.addToken(segment.count, this.token);
                    if (n3 - i > 3 && SyntaxUtilities.regionMatches(false, segment, n2, "=cut")) {
                        this.token = 0;
                    }
                    this.lastOffset = this.lastKeyword = n3;
                    break block37;
                }
                case 3: {
                    if (bl) {
                        bl = false;
                        continue block37;
                    }
                    if (c != '\"') continue block37;
                    this.addToken(n4 - this.lastOffset, this.token);
                    this.token = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    continue block37;
                }
                case 4: {
                    if (bl) {
                        bl = false;
                        continue block37;
                    }
                    if (c != '\'') continue block37;
                    this.addToken(n4 - this.lastOffset, (byte)3);
                    this.token = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    continue block37;
                }
                case 9: {
                    if (bl) {
                        bl = false;
                        continue block37;
                    }
                    if (c != '`') continue block37;
                    this.addToken(n4 - this.lastOffset, this.token);
                    this.token = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    continue block37;
                }
                default: {
                    throw new InternalError("Invalid state: " + this.token);
                }
            }
        }
        if (this.token == 0) {
            this.doKeyword(segment, n3, '\u0000');
        }
        switch (this.token) {
            case 7: {
                this.addToken(n3 - this.lastOffset, this.token);
                this.token = 0;
                break;
            }
            case 4: {
                this.addToken(n3 - this.lastOffset, (byte)3);
                break;
            }
            case 102: {
                this.addToken(n3 - this.lastOffset, (byte)4);
                this.token = 0;
                break;
            }
            case 100: 
            case 101: {
                this.addToken(n3 - this.lastOffset, (byte)10);
                this.token = 0;
                break;
            }
            default: {
                this.addToken(n3 - this.lastOffset, this.token);
            }
        }
        return this.token;
    }

    private boolean doKeyword(Segment segment, int n, char c) {
        int n2 = n + 1;
        if (this.token == 102) {
            this.addToken(n - this.lastOffset, (byte)4);
            this.token = 0;
            this.lastOffset = n;
            this.lastKeyword = n2;
            return false;
        }
        int n3 = n - this.lastKeyword;
        byte by = this.keywords.lookup(segment, this.lastKeyword, n3);
        if (by == 100 || by == 101) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(n3, (byte)4);
            this.lastOffset = n;
            this.lastKeyword = n2;
            this.matchChar = Character.isWhitespace(c) ? (char)'\u0000' : c;
            this.matchSpacesAllowed = true;
            this.token = by;
            return true;
        }
        if (by != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(n3, by);
            this.lastOffset = n;
        }
        this.lastKeyword = n2;
        return false;
    }

    private String createReadinString(char[] cArray, int n, int n2) {
        int n3;
        int n4 = n + n2 - 1;
        for (n3 = n; n3 <= n4 && !Character.isLetterOrDigit(cArray[n3]); ++n3) {
        }
        while (n3 <= n4 && !Character.isLetterOrDigit(cArray[n4])) {
            --n4;
        }
        return new String(cArray, n3, n4 - n3 + 1);
    }

    private static KeywordMap getKeywords() {
        if (perlKeywords == null) {
            perlKeywords = new KeywordMap(false);
            perlKeywords.add("my", (byte)6);
            perlKeywords.add("local", (byte)6);
            perlKeywords.add("new", (byte)6);
            perlKeywords.add("if", (byte)6);
            perlKeywords.add("until", (byte)6);
            perlKeywords.add("while", (byte)6);
            perlKeywords.add("elsif", (byte)6);
            perlKeywords.add("else", (byte)6);
            perlKeywords.add("eval", (byte)6);
            perlKeywords.add("unless", (byte)6);
            perlKeywords.add("foreach", (byte)6);
            perlKeywords.add("continue", (byte)6);
            perlKeywords.add("exit", (byte)6);
            perlKeywords.add("die", (byte)6);
            perlKeywords.add("last", (byte)6);
            perlKeywords.add("goto", (byte)6);
            perlKeywords.add("next", (byte)6);
            perlKeywords.add("redo", (byte)6);
            perlKeywords.add("goto", (byte)6);
            perlKeywords.add("return", (byte)6);
            perlKeywords.add("do", (byte)6);
            perlKeywords.add("sub", (byte)6);
            perlKeywords.add("use", (byte)6);
            perlKeywords.add("require", (byte)6);
            perlKeywords.add("package", (byte)6);
            perlKeywords.add("BEGIN", (byte)6);
            perlKeywords.add("END", (byte)6);
            perlKeywords.add("eq", (byte)9);
            perlKeywords.add("ne", (byte)9);
            perlKeywords.add("not", (byte)9);
            perlKeywords.add("and", (byte)9);
            perlKeywords.add("or", (byte)9);
            perlKeywords.add("abs", (byte)8);
            perlKeywords.add("accept", (byte)8);
            perlKeywords.add("alarm", (byte)8);
            perlKeywords.add("atan2", (byte)8);
            perlKeywords.add("bind", (byte)8);
            perlKeywords.add("binmode", (byte)8);
            perlKeywords.add("bless", (byte)8);
            perlKeywords.add("caller", (byte)8);
            perlKeywords.add("chdir", (byte)8);
            perlKeywords.add("chmod", (byte)8);
            perlKeywords.add("chomp", (byte)8);
            perlKeywords.add("chr", (byte)8);
            perlKeywords.add("chroot", (byte)8);
            perlKeywords.add("chown", (byte)8);
            perlKeywords.add("closedir", (byte)8);
            perlKeywords.add("close", (byte)8);
            perlKeywords.add("connect", (byte)8);
            perlKeywords.add("cos", (byte)8);
            perlKeywords.add("crypt", (byte)8);
            perlKeywords.add("dbmclose", (byte)8);
            perlKeywords.add("dbmopen", (byte)8);
            perlKeywords.add("defined", (byte)8);
            perlKeywords.add("delete", (byte)8);
            perlKeywords.add("die", (byte)8);
            perlKeywords.add("dump", (byte)8);
            perlKeywords.add("each", (byte)8);
            perlKeywords.add("endgrent", (byte)8);
            perlKeywords.add("endhostent", (byte)8);
            perlKeywords.add("endnetent", (byte)8);
            perlKeywords.add("endprotoent", (byte)8);
            perlKeywords.add("endpwent", (byte)8);
            perlKeywords.add("endservent", (byte)8);
            perlKeywords.add("eof", (byte)8);
            perlKeywords.add("exec", (byte)8);
            perlKeywords.add("exists", (byte)8);
            perlKeywords.add("exp", (byte)8);
            perlKeywords.add("fctnl", (byte)8);
            perlKeywords.add("fileno", (byte)8);
            perlKeywords.add("flock", (byte)8);
            perlKeywords.add("fork", (byte)8);
            perlKeywords.add("format", (byte)8);
            perlKeywords.add("formline", (byte)8);
            perlKeywords.add("getc", (byte)8);
            perlKeywords.add("getgrent", (byte)8);
            perlKeywords.add("getgrgid", (byte)8);
            perlKeywords.add("getgrnam", (byte)8);
            perlKeywords.add("gethostbyaddr", (byte)8);
            perlKeywords.add("gethostbyname", (byte)8);
            perlKeywords.add("gethostent", (byte)8);
            perlKeywords.add("getlogin", (byte)8);
            perlKeywords.add("getnetbyaddr", (byte)8);
            perlKeywords.add("getnetbyname", (byte)8);
            perlKeywords.add("getnetent", (byte)8);
            perlKeywords.add("getpeername", (byte)8);
            perlKeywords.add("getpgrp", (byte)8);
            perlKeywords.add("getppid", (byte)8);
            perlKeywords.add("getpriority", (byte)8);
            perlKeywords.add("getprotobyname", (byte)8);
            perlKeywords.add("getprotobynumber", (byte)8);
            perlKeywords.add("getprotoent", (byte)8);
            perlKeywords.add("getpwent", (byte)8);
            perlKeywords.add("getpwnam", (byte)8);
            perlKeywords.add("getpwuid", (byte)8);
            perlKeywords.add("getservbyname", (byte)8);
            perlKeywords.add("getservbyport", (byte)8);
            perlKeywords.add("getservent", (byte)8);
            perlKeywords.add("getsockname", (byte)8);
            perlKeywords.add("getsockopt", (byte)8);
            perlKeywords.add("glob", (byte)8);
            perlKeywords.add("gmtime", (byte)8);
            perlKeywords.add("grep", (byte)8);
            perlKeywords.add("hex", (byte)8);
            perlKeywords.add("import", (byte)8);
            perlKeywords.add("index", (byte)8);
            perlKeywords.add("int", (byte)8);
            perlKeywords.add("ioctl", (byte)8);
            perlKeywords.add("join", (byte)8);
            perlKeywords.add("keys", (byte)8);
            perlKeywords.add("kill", (byte)8);
            perlKeywords.add("lcfirst", (byte)8);
            perlKeywords.add("lc", (byte)8);
            perlKeywords.add("length", (byte)8);
            perlKeywords.add("link", (byte)8);
            perlKeywords.add("listen", (byte)8);
            perlKeywords.add("log", (byte)8);
            perlKeywords.add("localtime", (byte)8);
            perlKeywords.add("lstat", (byte)8);
            perlKeywords.add("map", (byte)8);
            perlKeywords.add("mkdir", (byte)8);
            perlKeywords.add("msgctl", (byte)8);
            perlKeywords.add("msgget", (byte)8);
            perlKeywords.add("msgrcv", (byte)8);
            perlKeywords.add("no", (byte)8);
            perlKeywords.add("oct", (byte)8);
            perlKeywords.add("opendir", (byte)8);
            perlKeywords.add("open", (byte)8);
            perlKeywords.add("ord", (byte)8);
            perlKeywords.add("pack", (byte)8);
            perlKeywords.add("pipe", (byte)8);
            perlKeywords.add("pop", (byte)8);
            perlKeywords.add("pos", (byte)8);
            perlKeywords.add("printf", (byte)8);
            perlKeywords.add("print", (byte)8);
            perlKeywords.add("push", (byte)8);
            perlKeywords.add("quotemeta", (byte)8);
            perlKeywords.add("rand", (byte)8);
            perlKeywords.add("readdir", (byte)8);
            perlKeywords.add("read", (byte)8);
            perlKeywords.add("readlink", (byte)8);
            perlKeywords.add("recv", (byte)8);
            perlKeywords.add("ref", (byte)8);
            perlKeywords.add("rename", (byte)8);
            perlKeywords.add("reset", (byte)8);
            perlKeywords.add("reverse", (byte)8);
            perlKeywords.add("rewinddir", (byte)8);
            perlKeywords.add("rindex", (byte)8);
            perlKeywords.add("rmdir", (byte)8);
            perlKeywords.add("scalar", (byte)8);
            perlKeywords.add("seekdir", (byte)8);
            perlKeywords.add("seek", (byte)8);
            perlKeywords.add("select", (byte)8);
            perlKeywords.add("semctl", (byte)8);
            perlKeywords.add("semget", (byte)8);
            perlKeywords.add("semop", (byte)8);
            perlKeywords.add("send", (byte)8);
            perlKeywords.add("setgrent", (byte)8);
            perlKeywords.add("sethostent", (byte)8);
            perlKeywords.add("setnetent", (byte)8);
            perlKeywords.add("setpgrp", (byte)8);
            perlKeywords.add("setpriority", (byte)8);
            perlKeywords.add("setprotoent", (byte)8);
            perlKeywords.add("setpwent", (byte)8);
            perlKeywords.add("setsockopt", (byte)8);
            perlKeywords.add("shift", (byte)8);
            perlKeywords.add("shmctl", (byte)8);
            perlKeywords.add("shmget", (byte)8);
            perlKeywords.add("shmread", (byte)8);
            perlKeywords.add("shmwrite", (byte)8);
            perlKeywords.add("shutdown", (byte)8);
            perlKeywords.add("sin", (byte)8);
            perlKeywords.add("sleep", (byte)8);
            perlKeywords.add("socket", (byte)8);
            perlKeywords.add("socketpair", (byte)8);
            perlKeywords.add("sort", (byte)8);
            perlKeywords.add("splice", (byte)8);
            perlKeywords.add("split", (byte)8);
            perlKeywords.add("sprintf", (byte)8);
            perlKeywords.add("sqrt", (byte)8);
            perlKeywords.add("srand", (byte)8);
            perlKeywords.add("stat", (byte)8);
            perlKeywords.add("study", (byte)8);
            perlKeywords.add("substr", (byte)8);
            perlKeywords.add("symlink", (byte)8);
            perlKeywords.add("syscall", (byte)8);
            perlKeywords.add("sysopen", (byte)8);
            perlKeywords.add("sysread", (byte)8);
            perlKeywords.add("syswrite", (byte)8);
            perlKeywords.add("telldir", (byte)8);
            perlKeywords.add("tell", (byte)8);
            perlKeywords.add("tie", (byte)8);
            perlKeywords.add("tied", (byte)8);
            perlKeywords.add("time", (byte)8);
            perlKeywords.add("times", (byte)8);
            perlKeywords.add("truncate", (byte)8);
            perlKeywords.add("uc", (byte)8);
            perlKeywords.add("ucfirst", (byte)8);
            perlKeywords.add("umask", (byte)8);
            perlKeywords.add("undef", (byte)8);
            perlKeywords.add("unlink", (byte)8);
            perlKeywords.add("unpack", (byte)8);
            perlKeywords.add("unshift", (byte)8);
            perlKeywords.add("untie", (byte)8);
            perlKeywords.add("utime", (byte)8);
            perlKeywords.add("values", (byte)8);
            perlKeywords.add("vec", (byte)8);
            perlKeywords.add("wait", (byte)8);
            perlKeywords.add("waitpid", (byte)8);
            perlKeywords.add("wantarray", (byte)8);
            perlKeywords.add("warn", (byte)8);
            perlKeywords.add("write", (byte)8);
            perlKeywords.add("m", (byte)100);
            perlKeywords.add("q", (byte)100);
            perlKeywords.add("qq", (byte)100);
            perlKeywords.add("qw", (byte)100);
            perlKeywords.add("qx", (byte)100);
            perlKeywords.add("s", (byte)101);
            perlKeywords.add("tr", (byte)101);
            perlKeywords.add("y", (byte)101);
        }
        return perlKeywords;
    }
}

