% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-mplus.R
\name{control_mplus}
\alias{control_mplus}
\title{Control aspects of fitting a model in Mplus}
\usage{
control_mplus(
  file = tempfile("irtree_"),
  overwrite = FALSE,
  cleanup = run,
  run = TRUE,
  estimator = "MLR",
  quadpts = 15,
  save_fscores = TRUE,
  analysis_list = list(COVERAGE = "0"),
  Mplus_command = "Mplus",
  warnings2messages = FALSE
)
}
\arguments{
\item{file}{String naming the file (or path) of the Mplus files and the data
file. Do not provide file endings, those will be automatically appended.}

\item{overwrite}{Logical value indicating whether data and input (if present)
files should be overwritten.}

\item{cleanup}{Logical, whether the Mplus files should be removed on exit.}

\item{run}{Logical, whether to indeed run Mplus.}

\item{estimator}{String, passed to argument 'ESTIMATOR' in Mplus.}

\item{quadpts}{This is passed to argument 'INTEGRATION' of Mplus. Thus, it
may be an integer specifying the number of integration points for the Mplus
default of rectangular numerical integration (e.g., \code{quadpts = 15}). Or it
may be a string, which gives more fine grained control (e.g., \code{quadpts = "MONTECARLO(2000)"}).}

\item{save_fscores}{Logical, whether to save FSCORES or not.}

\item{analysis_list}{Named list of strings passed to Mplus' argument
ANALYSIS. See examples below.}

\item{Mplus_command}{optional. N.B.: No need to pass this parameter for most users (has intelligent
defaults). Allows the user to specify the name/path of the Mplus executable to be used for
running models. This covers situations where Mplus is not in the system's path,
or where one wants to test different versions of the Mplus program.}

\item{warnings2messages}{Logical, whether Mplus errors and warnings should be
signaled as warnings (the default) or messages.}
}
\value{
A list with one element for every argument of \code{control_mplus()}.
}
\description{
This function should be used to generate the \code{control} argument of the
\code{\link[=fit.irtree_model]{fit()}} function.
}
\examples{
control_mplus(file = tempfile("irtree_", tmpdir = "."),
              quadpts = "GAUSS(10)",
              analysis_list = list(COVERAGE = "0",
                                   MITERATIONS = "500",
                                   MCONVERGENCE = ".001"))
}
