% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isofind.R
\name{isofind}
\alias{isofind}
\alias{print.isorix}
\alias{summary.isorix}
\title{Infer spatial origins}
\usage{
isofind(assign.data, isoscape, calibfit, mask = NA, verbose = interactive())
}
\arguments{
\item{assign.data}{A \var{dataframe} containing the assignment data (see
note below)}

\item{isoscape}{The output of the function \code{\link{isoscape}}}

\item{calibfit}{The output of the function \code{\link{calibfit}}}

\item{mask}{A \var{SpatialPolygons} of a mask to replace values on all
rasters by NA inside polygons (see details)}

\item{verbose}{A \var{logical} indicating whether information about the
progress of the procedure should be displayed or not while the function is
running. By default verbose is \var{TRUE} if users use an interactive R
session and \var{FALSE} otherwise.}
}
\value{
This function returns a \var{list} of class \var{isorix} containing
itself three lists (\code{indiv}, \code{group}, and \code{sp.points})
storing all rasters built during assignment and the spatial points for
sources and calibration. The \var{list} \code{indiv} contains three stack of
raster layers: one storing the value of the test statistic ("stat"), one
storing the value of the variance of the test statistic ("var") and one
storing the p-value of the test ("pv"). The \var{list} \code{group} contains
one raster storing the p-values of the assignment for the group. The
\var{list} \code{sp.points} contains two spatial point objects:
\code{source.points} and \code{calib.points}.
}
\description{
This function performs the assignment of organims of unknown origins.
}
\details{
An assignment is a comparison, for a given organism, of the predicted
isotopic value at its location of origin and the predicted isotopic value at
each location of the \code{isoscape}. The difference between these two
values constitute the statistic of the assingment test. Under the null
hypothesis (when the organism is at a location with the same isotopic value
than its original location), the test statistics follows a normal
distribution with mean zero and a certain variance that stems from both the
isoscape model fits and the calibration fit. The function \code{\link{isofind}}
computes the map of p-value for such an assignment test (i.e. the p-values in
all locations of the isoscape) for all individuals in the dataframe
\code{assign.data}. The function also performs a single assignment for the
entire group by combining the individual p-value maps using the Fisher's
method (Fisher 1925).

A mask can be used so to remove all values falling in the mask. This can be
useful for performing for example assignments on lands only and discard
anything falling in large bodies of water (see example). By default our
\code{\link{OceanMask}} is considered. Setting \code{mask} to NULL allows 
to prevent this automatic behaviour.
}
\note{
See \code{\link{AssignDataAlien}} to know which variables are needed to
perform the assignment and their names.
}
\examples{

## The examples below will only be run if sufficient time is allowed
## You can change that by typing e.g. IsoriX.options(example_maxtime = XX)
## if you want to allow for examples taking up to ca. XX seconds to run
## (so don't write XX but put a number instead!)

if(IsoriX.getOption("example_maxtime") > 120) {

## We fit the models for Germany
GNIPDataDEagg <- queryGNIP(data = GNIPDataDE)

GermanFit <- isofit(iso.data = GNIPDataDEagg)


## We build the isoscape
isoscape <- isoscape(elevation.raster = ElevRasterDE,
                     isofit = GermanFit)


## We fit the calibration model
calib <- calibfit(calib.data = CalibDataAlien,
                  isofit = GermanFit)

## We perform the assignment on land only
assignment.dry <- isofind(assign.data = AssignDataAlien,
                          isoscape = isoscape,
                          calibfit = calib)

## perform the assignment on land and water
assignment <- isofind(assign.data = AssignDataAlien,
                      isoscape = isoscape,
                      calibfit = calib,
                      mask = NULL)

## We plot the group assignment
plot(assignment, who = "group", mask = list(mask = NULL))

plot(assignment.dry, who = "group", mask = list(mask = NULL))

## We plot the assignment for the 8 first individuals
plot(assignment.dry, who = 1:8,
     sources = list(draw = FALSE),
     calib = list(draw = FALSE))

## We plot the assignment for the individual "Alien_10"
plot(assignment.dry, who = "Alien_10")

}

}
\references{
Fisher, R.A. (1925). Statistical Methods for Research Workers.
Oliver and Boyd (Edinburgh). ISBN 0-05-002170-2.
}
\seealso{
\code{\link{IsoriX}} for the complete workflow
}
\keyword{models}
\keyword{regression}
