% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateDenominatorCohortSet.R
\name{generateDenominatorCohortSet}
\alias{generateDenominatorCohortSet}
\title{Identify a set of denominator populations}
\usage{
generateDenominatorCohortSet(
  cdm,
  name = "denominator",
  cohortDateRange = NULL,
  ageGroup = list(c(0, 150)),
  sex = "Both",
  daysPriorHistory = 0,
  requirementInteractions = TRUE,
  strataTable = NULL,
  strataCohortId = NULL,
  closedCohort = FALSE,
  temporary = TRUE
)
}
\arguments{
\item{cdm}{A CDM reference object}

\item{name}{Name of the cohort table to be created.}

\item{cohortDateRange}{Two dates. The first indicating the earliest cohort
start date and the second indicating the latest possible cohort end date. If
NULL or the first date is set as missing, the earliest observation_start_date
in the observation_period table will be used for the former. If  NULL or the
second date is set as missing, the latest observation_end_date in the
observation_period table will be used for the latter.}

\item{ageGroup}{A list of age groups for which cohorts will be generated. A
value of \code{list(c(0,17), c(18,30))} would, for example, lead to the creation
of cohorts for those aged from 0 to 17 (up to the day before their 18th
birthday), and from 18 (starting the day of their 18th birthday) to 30 (up
to the day before their 31st birthday).}

\item{sex}{Sex of the cohorts. This can be one or more of: \code{"Male"},
\code{"Female"}, or \code{"Both"}.}

\item{daysPriorHistory}{The number of days of prior history observed in
the database required for an individual to start contributing time in
a cohort.}

\item{requirementInteractions}{If TRUE, cohorts will be created for
all combinations of ageGroup, sex, and daysPriorHistory. If FALSE, only the
first value specified for the other factors will be used. Consequently,
order of values matters when requirementInteractions is FALSE.}

\item{strataTable}{A cohort table in the cdm reference to use
to limit cohort entry and exit (with individuals only contributing to a
cohort when they are contributing to the cohort in the strata table).}

\item{strataCohortId}{The cohort definition id for the cohort of interest
in the strata table. If strataTable is specified, a single strataCohortId
must also be specified.}

\item{closedCohort}{If TRUE, a closed cohort will be defined where only
those individuals satisfying eligibility criteria on the start date
given in cohortDateRange are included.}

\item{temporary}{If TRUE, temporary tables will be used throughout. If
FALSE, permanent tables will be created in the write_schema of the cdm
using the write_prefix (if specified). Note existing permanent tables in
the write schema starting with the write_prefix will be at risk of being
dropped or overwritten.}
}
\value{
A cohort reference
}
\description{
\code{generateDenominatorCohortSet()} creates a set of cohorts that
can be used for the denominator population in analyses of incidence,
using \code{estimateIncidence()}, or prevalence, using \code{estimatePointPrevalence()}
or \code{estimatePeriodPrevalence()}.
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(sampleSize = 10000)
cdm$denominator <- generateDenominatorCohortSet(
  cdm = cdm,
  cohortDateRange = as.Date(c("2008-01-01", "2018-01-01"))
)
}
}
