% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmarkIncidencePrevalence.R
\name{benchmarkIncidencePrevalence}
\alias{benchmarkIncidencePrevalence}
\title{Run benchmark of incidence and prevalence analyses}
\usage{
benchmarkIncidencePrevalence(
  cdm,
  cohortDateRange = NULL,
  temporary = TRUE,
  returnParticipants = FALSE,
  nOutcomes = 1,
  prevOutcomes = 0.25,
  analysisType = "all",
  outputFolder = NULL,
  fileName = NULL
)
}
\arguments{
\item{cdm}{A CDM reference object}

\item{cohortDateRange}{Two dates. The first indicating the earliest cohort
start date and the second indicating the latest possible cohort end date. If
NULL or the first date is set as missing, the earliest observation_start_date
in the observation_period table will be used for the former. If  NULL or the
second date is set as missing, the latest observation_end_date in the
observation_period table will be used for the latter.}

\item{temporary}{If TRUE, temporary tables will be used throughout. If
FALSE, permanent tables will be created in the write_schema of the cdm
using the write_prefix (if specified). Note existing permanent tables in
the write schema starting with the write_prefix will be at risk of being
dropped or overwritten.}

\item{returnParticipants}{Whether to return participants (requires temporary
to be FALSE)}

\item{nOutcomes}{An integer specifying the number of outcomes to create in
the denominator cohort}

\item{prevOutcomes}{An array of integers for the prevalence of the outcomes
in the population (in \%). If the user wants all the outcomes with the same
prevalence, they can also provide a single integer}

\item{analysisType}{A string of the following: "all", "only incidence",
"only prevalence"}

\item{outputFolder}{Folder to save results as CSV}

\item{fileName}{Name given to CSV with results}
}
\value{
a tibble with time taken for different analyses
}
\description{
Run benchmark of incidence and prevalence analyses
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(
  sampleSize = 10000,
  earliestObservationStartDate = as.Date("2010-01-01"),
  latestObservationStartDate = as.Date("2018-01-01")
)
timings <- IncidencePrevalence::benchmarkIncidencePrevalence(cdm)
}
}
