\name{caChiTest}
\alias{caChiTest}
\title{
	caChiTest: correspondence analysis tests without resampling.
}
\description{
caChiTest performs 3 sets of chi-square tests along the lines of Lebart's v-tests. These tests are designed to be conservative estimates of chi-square tests on contingency data. The tests treat this data in a standard chi-square framework, but are helpful to understand correspondence analysis data when permutation and bootstrap become unfeasible.
}
\usage{
caChiTest(DATA, res, critical.value = 2)
}
\arguments{
  \item{DATA}{Data as would be entered for Correspondence Analysis (see \code{link{epCA}})}
  \item{res}{Results from correspondence analysis (e.g., output from \code{link{epCA}}). }
  \item{critical.value}{numeric. A value, analogous to a z- or t-score to be used to determine significance (via bootstrap ratio).}      
}
\value{
a list with the following values:\cr
\item{j.sig.vals}{boolean matrix. Identifies which column items are significant (based on \code{critical.value}).}
\item{j.signed.vals}{chi-square values associated to column items, multiplied by the sign of their component scores ($fj).}
\item{j.p.vals}{p values associated to column items in a chi-square test.}
\item{i.sig.vals}{boolean matrix. Identifies which row items are significant (based on \code{critical.value}).}
\item{i.signed.vals}{chi-square values associated to row items, multiplied by the sign of their component scores ($fi).}
\item{i.p.vals}{p values associated to row items in a chi-square test.}
\item{omni.val}{chi-square value associated to the table.}
\item{omni.p}{p value associated to a chi-square tests of the table.}
}
\author{
Derek Beaton
}
\seealso{
	\code{\link{epCA.inference.battery}}
}
\keyword{ inference }
\keyword{ correspondence analysis }
\keyword{ misc }
\keyword{ multivariate }
