% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{rm_holes}
\alias{rm_holes}
\title{Remove holes in a polygon}
\usage{
rm_holes(my_poly, poly_name = "notSpecified")
}
\arguments{
\item{my_poly}{\code{SpatialPolygon} object}

\item{poly_name}{character string to name polygon (defaults to "notSpecified")}
}
\value{
\code{SpatialPolygon} object with holes removed
}
\description{
Remove holes from a \code{SpatialPolygons} object.  Note that this function
differs from the function \code{findHoles} in that
it only removes holes contained within the polygon itself, not gaps between
the polygon and region boundaries
}
\examples{
with_holes <- bg_water[2]
plot(with_holes, col = "blue", main = "Polygon with Holes")
no_holes <- rm_holes(with_holes)
plot(no_holes, col = "blue", main = "Holes removed")
}
