% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_init_month}
\alias{get_init_month}
\title{Get initialization month}
\usage{
get_init_month(month, lag)
}
\arguments{
\item{month}{forecast month (integer from 1 to 12 corresponing to month of year)}

\item{lag}{months in advance prediction is being made (integer from 1 to 11).}
}
\value{
integer corresponding to the initialization month
}
\description{
Determine initialization month based on month being forecast and lag.
Considers lags up to 11 months in advance.
}
\details{
Note that this calculation assumes that the prediction for a month
         is its on first day. This differs from the labeling used in Director
         et al. (2017) which rounds up to the nearest full month.
}
\examples{
init_month <- get_init_month(month = 10, lag = 4)
init_month
}
