% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_p_subGaussian_NM.R
\name{get_p_subGaussian_NM}
\alias{get_p_subGaussian_NM}
\title{get_p_subGaussian_NM}
\usage{
get_p_subGaussian_NM(X, y, x0, sigma2, tau, rho = 0.5)
}
\arguments{
\item{X}{a numeric matrix specifying the covariates.}

\item{y}{a numeric vector with \code{length(y) == nrow(X)} specifying the
responses.}

\item{x0}{a numeric vector specifying the point of interest, such that
\code{length(x0) == ncol(X)}.}

\item{sigma2}{a single positive numeric value specifying the variance parameter.}

\item{tau}{a single numeric value specifying the threshold of interest.}

\item{rho}{a single positive numeric value serving as hyperparameter.}
}
\value{
A single numeric value in (0, 1].
}
\description{
Calculate the p-value in Definition 18 of \insertCite{MRCS2023;textual}{ISS}.
}
\examples{
set.seed(123)
n <- 100
d <- 2
X <- matrix(runif(d * n), ncol = d)
eta <- function(x) sum(x)
y <- apply(X, MARGIN = 1, FUN = eta) + rnorm(n, sd = 0.5)
get_p_subGaussian_NM(X, y, x0 = c(1, 1), sigma2 = 0.25, tau = 3)
get_p_subGaussian_NM(X, y, x0 = c(1, 1), sigma2 = 0.25, tau = 1)
get_p_subGaussian_NM(X, y, x0 = c(1, 1), sigma2 = 0.25, tau = 1, rho = 2)


}
\references{
\insertRef{MRCS2023}{ISS}
}
