% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.irtest.R
\name{print.irtest_summary}
\alias{print.irtest_summary}
\title{Print of the summary}
\usage{
\method{print}{irtest_summary}(x, ...)
}
\arguments{
\item{x}{An object returned from \code{\link{summary.irtest}}.}

\item{...}{Additional arguments (currently nonfunctioning).}
}
\value{
Printed summarized texts on the console.
}
\description{
This function prints the summarized information.
}
\examples{
Alldata <- DataGeneration(seed = 1,
                          #model_D = rep(1, 10),
                          N=1000,
                          nitem_D = 0,
                          nitem_P = 8,
                          categ = rep(3:4,each = 4),
                          latent_dist = "2NM",
                          d = 1.664,
                          sd_ratio = 2,
                          prob = 0.3)
data <- Alldata$data_P
item <- Alldata$item_P
initialitem <- Alldata$initialitem_P
theta <- Alldata$theta
M1 <- IRTest_Poly(initialitem = initialitem,
                  data = data,
                  model = "GPCM",
                  latent_dist = "Mixture",
                  max_iter = 200,
                  threshold = .001,
                  )

summary(M1)


}
\author{
Seewoo Li \email{cu@yonsei.ac.kr}
}
